/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.registry.lazy;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public record LazyHolder<T>(T value, Supplier<ResourceKey<T>> key) implements Holder<T>
{
    public boolean isBound() {
        return true;
    }

    public boolean is(ResourceLocation name) {
        return name.equals((Object)this.key.get().location());
    }

    public boolean is(ResourceKey<T> key) {
        return key == this.key.get();
    }

    public boolean is(Predicate<ResourceKey<T>> test) {
        return test.test(this.key.get());
    }

    public boolean is(TagKey<T> tag) {
        return false;
    }

    public boolean is(Holder<T> holder) {
        return holder.unwrapKey().map(this::is).orElse(false);
    }

    public Stream<TagKey<T>> tags() {
        return Stream.empty();
    }

    public Either<ResourceKey<T>, T> unwrap() {
        return Either.left(this.key.get());
    }

    public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.key.get());
    }

    public Holder.Kind kind() {
        return Holder.Kind.DIRECT;
    }

    public boolean canSerializeIn(HolderOwner<T> owner) {
        return true;
    }
}

