/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.util;

import com.terrano.mod.Terrano;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;

public class TagLoader {
    private static final Executor DIRECT_EXECUTOR = Runnable::run;

    public static void bindTags(RegistryAccess access) {
        ArrayList<Object> sources = new ArrayList<Object>();
        try {
            VanillaPackResources vanillaPack = TagLoader.createVanillaPack();
            if (vanillaPack != null) {
                sources.add(vanillaPack);
            }
        }
        catch (Exception e) {
            Terrano.LOG.warn("Failed to create vanilla pack for tag loading", (Throwable)e);
        }
        for (IModFileInfo modContainer : ModList.get().getModFiles()) {
            try {
                IModFile modFile = modContainer.getFile();
                PackResources pack = TagLoader.createModPack(modFile);
                if (pack == null) continue;
                sources.add(pack);
            }
            catch (Exception exception) {}
        }
        if (sources.isEmpty()) {
            Terrano.LOG.warn("No resource packs available for tag loading");
            return;
        }
        try (MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, sources);){
            TagLoader.bindTags(access, (ResourceManager)resourceManager);
        }
    }

    private static VanillaPackResources createVanillaPack() {
        try {
            PackLocationInfo locationInfo = new PackLocationInfo("vanilla", (Component)Component.literal((String)"Vanilla"), PackSource.BUILT_IN, Optional.empty());
            return new VanillaPackResourcesBuilder().pushJarResources().exposeNamespace(new String[]{"minecraft"}).build(locationInfo);
        }
        catch (Exception e) {
            Terrano.LOG.warn("Failed to create vanilla pack", (Throwable)e);
            return null;
        }
    }

    private static PackResources createModPack(IModFile modFile) {
        try {
            Path path = modFile.getFilePath();
            List modInfos = modFile.getModInfos();
            if (modInfos.isEmpty()) {
                return null;
            }
            IModInfo modInfo = (IModInfo)modInfos.get(0);
            String modId = modInfo.getModId();
            String displayName = modInfo.getDisplayName();
            PackLocationInfo locationInfo = new PackLocationInfo(modId, (Component)Component.literal((String)displayName), PackSource.DEFAULT, Optional.empty());
            return new PathPackResources(locationInfo, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void bindTags(RegistryAccess access, ResourceManager resources) {
        try {
            TagManager tagManager = new TagManager(access);
            tagManager.reload(TagLoader::complete, resources, (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, DIRECT_EXECUTOR, DIRECT_EXECUTOR);
            List result = tagManager.getResult();
            for (TagManager.LoadResult entry : result) {
                TagLoader.bind(entry, access);
            }
        }
        catch (Exception e) {
            Terrano.LOG.error("Failed to bind tags", (Throwable)e);
        }
    }

    private static <T> void bind(TagManager.LoadResult<T> result, RegistryAccess access) {
        Optional optRegistry = access.registry(result.key());
        if (optRegistry.isEmpty()) {
            return;
        }
        Registry registry = (Registry)optRegistry.get();
        Map<TagKey, List> tags = result.tags().entrySet().stream().collect(Collectors.toMap(e -> TagKey.create((ResourceKey)result.key(), (ResourceLocation)((ResourceLocation)e.getKey())), e -> List.copyOf((Collection)e.getValue())));
        registry.bindTags(tags);
    }

    @Nonnull
    private static <T> CompletableFuture<T> complete(T t) {
        return CompletableFuture.completedFuture(t);
    }
}

