/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen;

import com.mojang.serialization.MapCodec;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.Terrano;
import com.terrano.mod.data.ModRegistries;
import com.terrano.mod.worldgen.GeneratorCodec;
import com.terrano.mod.worldgen.GeneratorPreset;
import com.terrano.mod.worldgen.GeneratorResource;
import com.terrano.mod.worldgen.IGenerator;
import com.terrano.mod.worldgen.Seeds;
import com.terrano.mod.worldgen.VanillaGen;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.mod.worldgen.biome.BiomeGenerator;
import com.terrano.mod.worldgen.biome.Source;
import com.terrano.mod.worldgen.noise.INoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseSample;
import com.terrano.mod.worldgen.noise.climate.ClimateSample;
import com.terrano.mod.worldgen.terrain.TerrainCache;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import com.terrano.mod.worldgen.util.ChunkUtil;
import com.terrano.mod.worldgen.util.ThreadPool;
import com.terrano.noise.Module;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class Generator
extends ChunkGenerator
implements IGenerator {
    public static final MapCodec<Generator> CODEC = new GeneratorCodec();
    public static final AtomicReference<RegistryAccess> PENDING_REGISTRY_ACCESS = new AtomicReference<Object>(null);
    protected final TerrainLevels levels;
    protected volatile VanillaGen vanillaGen;
    protected volatile BiomeGenerator biomeGenerator;
    protected volatile INoiseGenerator noiseGenerator;
    protected volatile TerrainCache terrainCache;
    protected volatile boolean fullyInitialized = false;
    protected final ThreadLocal<GeneratorResource> localResource = ThreadLocal.withInitial(GeneratorResource::new);
    protected volatile int cachedSeed = 0;
    protected volatile long worldSeed = 0L;
    protected volatile RegistryAccess earlyRegistryAccess;

    public Generator(TerrainLevels levels) {
        super((BiomeSource)new Source());
        this.levels = levels;
    }

    public Generator(TerrainLevels levels, RegistryAccess earlyAccess) {
        super((BiomeSource)new Source());
        this.levels = levels;
        this.earlyRegistryAccess = earlyAccess;
        if (earlyAccess != null) {
            this.getSource().initBiomes(earlyAccess);
        }
    }

    public Generator(TerrainLevels levels, VanillaGen vanillaGen, Source biomeSource, BiomeGenerator biomeGenerator, INoiseGenerator noiseGenerator) {
        super((BiomeSource)biomeSource);
        this.levels = levels;
        this.vanillaGen = vanillaGen;
        this.biomeGenerator = biomeGenerator;
        this.noiseGenerator = noiseGenerator;
        this.terrainCache = new TerrainCache(levels, noiseGenerator);
        this.fullyInitialized = true;
    }

    public TerrainLevels getLevels() {
        return this.levels;
    }

    public void setEarlyRegistryAccess(RegistryAccess access) {
        this.earlyRegistryAccess = access;
    }

    public Source getSource() {
        BiomeSource bs = this.biomeSource;
        if (bs instanceof Source) {
            Source source = (Source)bs;
            return source;
        }
        throw new IllegalStateException("BiomeSource is not a Terrano Source: " + String.valueOf(bs));
    }

    private synchronized void ensureInitialized(RegistryAccess registries) {
        if (this.fullyInitialized) {
            return;
        }
        Terrano.LOG.info("Initializing Generator with RegistryAccess");
        try {
            TerrainNoise[] terrain = this.loadTerrainNoises(registries);
            Terrano.LOG.info("Loaded {} terrain entries", (Object)terrain.length);
            for (TerrainNoise t : terrain) {
                Terrano.LOG.debug("  - {} (weight: {})", (Object)t.terrain().getName(), (Object)Float.valueOf(t.weight()));
            }
            this.noiseGenerator = new NoiseGenerator(this.levels, terrain).withErosion();
            this.biomeGenerator = new BiomeGenerator(registries);
            Source source = this.getSource();
            source.initialize(this.noiseGenerator, registries);
            this.vanillaGen = GeneratorPreset.getVanillaGen(source, registries);
            this.terrainCache = new TerrainCache(this.levels, this.noiseGenerator);
            this.fullyInitialized = true;
            Terrano.LOG.info("Generator fully initialized with {} terrain types, {} possible biomes", (Object)terrain.length, (Object)source.possibleBiomes().size());
        }
        catch (Exception e) {
            Terrano.LOG.error("Failed to initialize Generator", (Throwable)e);
            throw e;
        }
    }

    private TerrainNoise[] loadTerrainNoises(RegistryAccess registries) {
        try {
            Optional optionalRegistry = registries.registry(ModRegistries.TERRAIN_NOISE_KEY);
            if (optionalRegistry.isPresent()) {
                Registry registry = (Registry)optionalRegistry.get();
                Set entries = registry.entrySet();
                if (!entries.isEmpty()) {
                    Terrano.LOG.info("Found {} terrain entries in datapack registry", (Object)entries.size());
                    return (TerrainNoise[])entries.stream().sorted(Comparator.comparing(e -> ((ResourceKey)e.getKey()).location())).map(e -> (TerrainNoise)e.getValue()).filter(t -> t != null && t.noise() != null && t.terrain() != null).toArray(TerrainNoise[]::new);
                }
                Terrano.LOG.warn("Terrain registry exists but is empty");
            } else {
                Terrano.LOG.warn("Terrain registry not found: {}", (Object)ModRegistries.TERRAIN_NOISE_KEY.location());
            }
        }
        catch (Exception e2) {
            Terrano.LOG.error("Error loading terrain from registry: {}", (Object)e2.getMessage());
        }
        Terrano.LOG.warn("Using fallback terrain types");
        return Generator.createFallbackTerrains();
    }

    private static TerrainNoise[] createFallbackTerrains() {
        Terrano.LOG.info("Creating fallback terrain types...");
        return new TerrainNoise[]{Generator.createFallbackTerrain("plains", com.terrano.engine.world.terrain.TerrainType.FLATS, 2.5f, 0.02f, 400, 0.15f), Generator.createFallbackTerrain("rolling_hills", com.terrano.engine.world.terrain.TerrainType.FLATS, 2.0f, 0.03f, 300, 0.2f), Generator.createFallbackTerrain("hills", com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, 0.02f, 200, 0.6f), Generator.createFallbackTerrain("plateau", com.terrano.engine.world.terrain.TerrainType.PLATEAU, 1.5f, 0.25f, 350, 0.1f), Generator.createSoftMountain("mountains_soft", com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.2f, 0.1f), Generator.createRidgeMountain("mountains_ridge", com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.5f, 0.1f), Generator.createMixedMountain("mountain_chain", com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.0f, 0.12f), Generator.createJaggedPeaks("jagged_peaks", com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 0.5f, 0.18f)};
    }

    private static TerrainNoise createSoftMountain(String name, Terrain parentTerrain, float weight, float baseHeight) {
        int seed = name.hashCode();
        Module noise = com.terrano.noise.Source.simplex(seed, 250, 5).scale(0.8).bias(baseHeight).warp(seed + 100, 400, 3, 200.0).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    private static TerrainNoise createRidgeMountain(String name, Terrain parentTerrain, float weight, float baseHeight) {
        int seed = name.hashCode();
        Module ridges = com.terrano.noise.Source.build(seed, 400, 4).lacunarity(2.4).gain(0.6).simplexRidge().pow(0.8).scale(0.85).bias(baseHeight);
        Module shape = com.terrano.noise.Source.simplex(seed + 111, 700, 3).clamp(0.25, 1.0).map(0.0, 1.0);
        Module detail = com.terrano.noise.Source.simplex(seed + 222, 100, 3).scale(0.08);
        Module noise = shape.mult(ridges).add(detail).warp(seed + 333, 500, 3, 250.0).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    private static TerrainNoise createMixedMountain(String name, Terrain parentTerrain, float weight, float baseHeight) {
        int seed = name.hashCode();
        Module base = com.terrano.noise.Source.simplex(seed, 350, 4).scale(0.55).bias(baseHeight);
        Module ridges = com.terrano.noise.Source.build(seed + 100, 250, 4).lacunarity(2.5).gain(0.65).simplexRidge().pow(0.85).scale(0.35);
        Module ridgeMask = base.clamp(0.3, 0.7).map(0.0, 1.0);
        Module noise = base.add(ridgeMask.mult(ridges)).warp(seed + 200, 450, 3, 220.0).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    private static TerrainNoise createJaggedPeaks(String name, Terrain parentTerrain, float weight, float baseHeight) {
        int seed = name.hashCode();
        Module mainRidge = com.terrano.noise.Source.build(seed, 300, 5).lacunarity(2.6).gain(0.65).simplexRidge().pow(0.7).scale(0.9).bias(baseHeight);
        Module crossRidge = com.terrano.noise.Source.build(seed + 500, 200, 4).lacunarity(2.4).gain(0.6).simplexRidge().pow(0.75).scale(0.3);
        Module mask = com.terrano.noise.Source.simplex(seed + 700, 900, 2).clamp(0.35, 1.0).map(0.0, 1.0);
        Module noise = mask.mult(mainRidge.add(crossRidge)).warp(seed + 900, 400, 3, 200.0).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    private static TerrainNoise createFallbackTerrain(String name, Terrain parentTerrain, float weight, float baseHeight, int noiseScale, float amplitude) {
        Module noise = com.terrano.noise.Source.simplex(name.hashCode(), noiseScale, 3).scale(amplitude).bias(baseHeight).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    public void initWithSeed(long seed) {
        this.cachedSeed = (int)seed;
        this.worldSeed = seed;
        this.getSource().withSeed(seed);
        Seeds.setSeed(seed);
    }

    public VanillaGen getVanillaGen() {
        return this.vanillaGen;
    }

    public INoiseGenerator getNoiseGenerator() {
        return this.noiseGenerator;
    }

    public TerrainData getChunkData(int seed, ChunkPos pos) {
        return this.terrainCache.getNow(seed, pos);
    }

    public CompletableFuture<TerrainData> getChunkDataAsync(int seed, ChunkPos pos) {
        return this.terrainCache.getAsync(seed, pos);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public int getMinY() {
        return this.levels.minY;
    }

    public int getSeaLevel() {
        return this.levels.seaLevel;
    }

    public int getGenDepth() {
        return this.levels.maxY;
    }

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> structureSetLookup, RandomState randomState, long seed) {
        this.worldSeed = seed;
        this.initWithSeed(seed);
        Source source = this.getSource();
        if (source.possibleBiomes().isEmpty()) {
            Terrano.LOG.warn("createState: possibleBiomes is EMPTY! Attempting init...");
            RegistryAccess access = this.earlyRegistryAccess;
            if (access == null && (access = PENDING_REGISTRY_ACCESS.get()) != null) {
                Terrano.LOG.info("createState: Got RegistryAccess from PENDING_REGISTRY_ACCESS");
                this.earlyRegistryAccess = access;
            }
            if (access != null) {
                source.initBiomes(access);
                try {
                    this.ensureInitialized(access);
                }
                catch (Exception e) {
                    Terrano.LOG.info("createState: Full init deferred, biomes={}", (Object)source.possibleBiomes().size());
                }
            } else {
                Terrano.LOG.error("createState: No RegistryAccess available! Structures will NOT generate!");
            }
        }
        Terrano.LOG.info("createState: seed={}, possibleBiomes={}, initialized={}", (Object)seed, (Object)source.possibleBiomes().size(), (Object)source.isInitialized());
        return super.createState(structureSetLookup, randomState, seed);
    }

    public void forceInitialize(RegistryAccess registries) {
        this.ensureInitialized(registries);
    }

    public void createStructures(RegistryAccess registryAccess, ChunkGeneratorStructureState structureState, StructureManager structureManager, ChunkAccess chunk, StructureTemplateManager templateManager) {
        this.ensureInitialized(registryAccess);
        if (this.worldSeed == 0L) {
            this.worldSeed = structureState.getLevelSeed();
            this.initWithSeed(this.worldSeed);
        }
        if (this.terrainCache != null) {
            this.terrainCache.hint(this.cachedSeed, chunk.getPos());
        }
        super.createStructures(registryAccess, structureState, structureManager, chunk, templateManager);
    }

    public void createReferences(WorldGenLevel level, StructureManager structureFeatures, ChunkAccess chunk) {
        this.ensureInitialized(level.registryAccess());
        if (this.worldSeed == 0L) {
            this.worldSeed = level.getSeed();
            this.initWithSeed(this.worldSeed);
        }
        if (this.terrainCache != null) {
            this.terrainCache.hint(this.cachedSeed, chunk.getPos());
        }
        super.createReferences(level, structureFeatures, chunk);
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState state, StructureManager structureManager, ChunkAccess chunkAccess) {
        if (!this.fullyInitialized || this.terrainCache == null) {
            Terrano.LOG.error("Generator not initialized during fillFromNoise!");
            return CompletableFuture.completedFuture(chunkAccess);
        }
        if (this.cachedSeed == 0 && this.worldSeed != 0L) {
            this.initWithSeed(this.worldSeed);
        }
        this.terrainCache.hint(this.cachedSeed, chunkAccess.getPos());
        return this.terrainCache.combineAsync(ThreadPool.EXECUTOR, this.cachedSeed, chunkAccess, (chunk, terrainData) -> {
            ChunkUtil.fillChunk(this.getSeaLevel(), chunk, terrainData, this.localResource.get());
            ChunkUtil.primeHeightmaps(this.getSeaLevel(), chunk, terrainData, ChunkUtil.FILLER);
            ChunkUtil.buildStructureTerrain(chunk, terrainData, structureManager);
            return chunk;
        });
    }

    public void buildSurface(WorldGenRegion region, StructureManager structures, RandomState state, ChunkAccess chunk) {
        this.ensureInitialized(region.registryAccess());
        this.initSeedFromRegion(region);
        if (this.biomeGenerator != null) {
            this.biomeGenerator.surface(chunk, region, state, this);
        }
    }

    public void applyCarvers(WorldGenRegion region, long seed, RandomState state, BiomeManager biomes, StructureManager structures, ChunkAccess chunk, GenerationStep.Carving stage) {
        this.ensureInitialized(region.registryAccess());
        this.initSeedFromRegion(region);
        if (this.biomeGenerator != null) {
            this.biomeGenerator.carve(seed, chunk, region, biomes, stage, this);
        }
    }

    public void applyBiomeDecoration(WorldGenLevel region, ChunkAccess chunk, StructureManager structures) {
        this.ensureInitialized(region.registryAccess());
        this.initSeedFromLevel(region);
        if (this.biomeGenerator != null) {
            this.biomeGenerator.decorate(chunk, region, structures, this);
        }
        if (this.terrainCache != null) {
            this.terrainCache.drop(this.cachedSeed, chunk.getPos());
        }
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
        this.ensureInitialized(region.registryAccess());
        if (this.vanillaGen == null) {
            return;
        }
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.vanillaGen.getSettings().value();
        if (settings.disableMobGeneration()) {
            return;
        }
        ChunkPos chunkPos = region.getCenter();
        BlockPos position = chunkPos.getWorldPosition().atY(region.getMaxBuildHeight() - 1);
        Holder holder = region.getBiome(position);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.getSeed()));
        random.setDecorationSeed(region.getSeed(), chunkPos.getMinBlockX(), chunkPos.getMinBlockZ());
        NaturalSpawner.spawnMobsForChunkGeneration((ServerLevelAccessor)region, (Holder)holder, (ChunkPos)chunkPos, (RandomSource)random);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState state) {
        if (!this.fullyInitialized || this.terrainCache == null) {
            return this.levels.seaLevel;
        }
        if (this.cachedSeed == 0 && this.worldSeed != 0L) {
            this.initWithSeed(this.worldSeed);
        }
        NoiseSample sample = this.terrainCache.getSample(this.cachedSeed, x, z);
        float scaledBase = this.levels.getScaledBaseLevel(sample.baseNoise);
        float scaledHeight = this.levels.getScaledHeight(sample.heightNoise);
        int base = this.levels.getHeight(scaledBase);
        int height = this.levels.getHeight(scaledHeight);
        return switch (types) {
            default -> throw new MatchException(null, null);
            case Heightmap.Types.WORLD_SURFACE, Heightmap.Types.WORLD_SURFACE_WG, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES -> Math.max(base, height) + 1;
            case Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.OCEAN_FLOOR_WG -> height + 1;
        };
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState state) {
        if (!this.fullyInitialized || this.terrainCache == null) {
            return new NoiseColumn(this.levels.seaLevel, new BlockState[0]);
        }
        if (this.cachedSeed == 0 && this.worldSeed != 0L) {
            this.initWithSeed(this.worldSeed);
        }
        NoiseSample sample = this.terrainCache.getSample(this.cachedSeed, x, z);
        float scaledBase = this.levels.getScaledBaseLevel(sample.baseNoise);
        float scaledHeight = this.levels.getScaledHeight(sample.heightNoise);
        int base = this.levels.getHeight(scaledBase);
        int height = this.levels.getHeight(scaledHeight);
        int surface = Math.max(base, height);
        Object[] states = new BlockState[surface];
        Arrays.fill(states, 0, height, Blocks.STONE.defaultBlockState());
        if (surface > height) {
            Arrays.fill(states, height, surface, Blocks.WATER.defaultBlockState());
        }
        return new NoiseColumn(height, (BlockState[])states);
    }

    public void addDebugScreenInfo(List<String> lines, RandomState state, BlockPos pos) {
        if (!this.fullyInitialized) {
            lines.add("[Terrano] Not initialized");
            return;
        }
        ClimateSample sample = this.getSource().getBiomeSampler().getSample();
        this.terrainCache.sample(this.cachedSeed, pos.getX(), pos.getZ(), sample);
        this.getSource().getBiomeSampler().sample(this.cachedSeed, pos.getX(), pos.getZ(), sample);
        lines.add("");
        lines.add("[Terrano]");
        lines.add("Terrain Type: " + sample.terrainType.getName());
        lines.add("Climate Type: " + sample.climateType.name());
        lines.add("Base Noise: " + sample.baseNoise);
        lines.add("Height Noise: " + sample.heightNoise);
        lines.add("Ocean Proximity: " + (1.0f - sample.continentNoise));
        lines.add("River Proximity: " + (1.0f - sample.riverNoise));
    }

    private void initSeedFromLevel(WorldGenLevel level) {
        if (this.cachedSeed == 0) {
            this.initWithSeed(level.getSeed());
        }
    }

    private void initSeedFromRegion(WorldGenRegion region) {
        if (this.cachedSeed == 0) {
            this.initWithSeed(region.getSeed());
        }
    }

    public static boolean isTerrano(ChunkGenerator generator) {
        return generator instanceof Generator;
    }
}

