/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;

public class GeneratorCodec
extends MapCodec<Generator> {
    private static final MapCodec<TerrainLevels> LEVELS_CODEC = TerrainLevels.CODEC.optionalFieldOf("levels", (Object)TerrainLevels.DEFAULT.get());

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return LEVELS_CODEC.keys(ops);
    }

    public <T> DataResult<Generator> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult levelsResult = LEVELS_CODEC.decode(ops, input);
        return levelsResult.map(levels -> {
            RegistryAccess registryAccess = null;
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                registryAccess = GeneratorCodec.tryGetRegistryAccess(registryOps);
            }
            if (registryAccess != null) {
                Terrano.LOG.info("GeneratorCodec: Captured RegistryAccess during decode! Structures will work.");
                return new Generator((TerrainLevels)levels, registryAccess);
            }
            Terrano.LOG.warn("GeneratorCodec: No RegistryAccess during decode. Will attempt init later.");
            return new Generator((TerrainLevels)levels);
        });
    }

    public <T> RecordBuilder<T> encode(Generator generator, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return LEVELS_CODEC.encode((Object)generator.getLevels(), ops, prefix);
    }

    private static <T> RegistryAccess tryGetRegistryAccess(RegistryOps<T> registryOps) {
        try {
            for (Class<?> clazz = registryOps.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    RegistryAccess nested;
                    field.setAccessible(true);
                    Object value = field.get(registryOps);
                    if (value instanceof RegistryAccess) {
                        RegistryAccess access = (RegistryAccess)value;
                        Terrano.LOG.debug("GeneratorCodec: Found RegistryAccess in field '{}'", (Object)field.getName());
                        return access;
                    }
                    if (value == null || GeneratorCodec.isPrimitive(value) || (nested = GeneratorCodec.findRegistryAccessIn(value, 0)) == null) continue;
                    Terrano.LOG.debug("GeneratorCodec: Found RegistryAccess nested in field '{}'", (Object)field.getName());
                    return nested;
                }
            }
        }
        catch (Exception e) {
            Terrano.LOG.debug("GeneratorCodec: Failed to extract RegistryAccess: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static RegistryAccess findRegistryAccessIn(Object obj, int depth) {
        if (obj instanceof RegistryAccess) {
            RegistryAccess access = (RegistryAccess)obj;
            return access;
        }
        if (depth > 3) {
            return null;
        }
        try {
            for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    RegistryAccess nested;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value instanceof RegistryAccess) {
                        RegistryAccess access = (RegistryAccess)value;
                        return access;
                    }
                    if (value == null || GeneratorCodec.isPrimitive(value) || depth >= 3 || (nested = GeneratorCodec.findRegistryAccessIn(value, depth + 1)) == null) continue;
                    return nested;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isPrimitive(Object obj) {
        return obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character || obj instanceof Enum || obj.getClass().isArray() || obj instanceof Collection || obj instanceof Map;
    }
}

