/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen;

import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.VanillaGen;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.biome.BiomeGenerator;
import com.terrano.mod.worldgen.biome.Source;
import com.terrano.mod.worldgen.noise.INoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseGenerator;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class GeneratorPreset {
    public static Generator build(TerrainLevels levels, RegistryAccess registries) {
        TerrainNoise[] terrain = Terrano.TERRAINS.entries(registries, TerrainNoise[]::new);
        BiomeGenerator biomeGenerator = new BiomeGenerator(registries);
        INoiseGenerator noiseGenerator = new NoiseGenerator(levels, terrain).withErosion();
        Source biomeSource = new Source(noiseGenerator, registries);
        VanillaGen vanillaGen = GeneratorPreset.getVanillaGen(biomeSource, registries);
        return new Generator(levels, vanillaGen, biomeSource, biomeGenerator, noiseGenerator);
    }

    public static LevelStem getDefault(RegistryAccess registries) {
        Generator generator = GeneratorPreset.build(TerrainLevels.DEFAULT.get().copy(), registries);
        Registry type = registries.registryOrThrow(Registries.DIMENSION_TYPE);
        return new LevelStem((Holder)type.getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD), (ChunkGenerator)generator);
    }

    public static VanillaGen getVanillaGen(BiomeSource biomes, RegistryAccess access) {
        Holder.Reference settings = access.registryOrThrow(Registries.NOISE_SETTINGS).getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD);
        return new VanillaGen(biomes, (Holder<NoiseGeneratorSettings>)settings);
    }

    public static boolean isTerraForgedWorld(ServerLevel level) {
        return GeneratorPreset.getGenerator(level) != null;
    }

    public static Generator getGenerator(ServerLevel level) {
        return GeneratorPreset.getGenerator(level.getChunkSource().getGenerator());
    }

    private static Generator getGenerator(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof Generator) {
            Generator generator = (Generator)chunkGenerator;
            return generator;
        }
        return null;
    }
}

