/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.carver.CarvingContext;

public class VanillaGen {
    protected final NoiseBasedChunkGenerator vanillaGenerator;
    protected final Holder<NoiseGeneratorSettings> settings;
    protected final int lavaLevel;
    protected final Aquifer.FluidStatus fluidStatus1;
    protected final Aquifer.FluidStatus fluidStatus2;
    protected final Aquifer.FluidPicker globalFluidPicker;

    public VanillaGen(BiomeSource biomeSource, VanillaGen other) {
        this(biomeSource, other.settings);
    }

    public VanillaGen(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        this.settings = settings;
        this.lavaLevel = Math.min(-54, ((NoiseGeneratorSettings)settings.value()).seaLevel());
        this.fluidStatus1 = new Aquifer.FluidStatus(-54, Blocks.LAVA.defaultBlockState());
        this.fluidStatus2 = new Aquifer.FluidStatus(((NoiseGeneratorSettings)settings.value()).seaLevel(), ((NoiseGeneratorSettings)settings.value()).defaultFluid());
        this.globalFluidPicker = (x, y, z) -> y < this.lavaLevel ? this.fluidStatus1 : this.fluidStatus2;
        this.vanillaGenerator = new NoiseBasedChunkGenerator(biomeSource, settings);
    }

    public Holder<NoiseGeneratorSettings> getSettings() {
        return this.settings;
    }

    public Aquifer.FluidPicker getGlobalFluidPicker() {
        return this.globalFluidPicker;
    }

    public CarvingContext createCarvingContext(WorldGenRegion region, ChunkAccess chunk, NoiseChunk noiseChunk, RandomState state) {
        return new CarvingContext(this.vanillaGenerator, region.registryAccess(), chunk.getHeightAccessorForGeneration(), noiseChunk, state, null);
    }
}

