/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.asset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.data.codec.LazyCodec;
import com.terrano.mod.util.seed.ContextSeedable;
import com.terrano.mod.util.storage.WeightMap;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.mod.worldgen.noise.NoiseCodec;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import java.util.Comparator;
import net.minecraft.core.Holder;

public class TerrainNoise
implements ContextSeedable<TerrainNoise>,
WeightMap.Weighted {
    public static final TerrainNoise NONE = new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)TerrainType.NONE), 0.0f, Source.ZERO);
    public static final Comparator<TerrainNoise> COMPARATOR = Comparator.comparing(t -> t.terrain().getName());
    public static final Codec<TerrainNoise> CODEC = LazyCodec.record(instance -> instance.group((App)TerrainType.CODEC.fieldOf("type").forGetter(TerrainNoise::type), (App)Codec.FLOAT.fieldOf("weight").forGetter(TerrainNoise::weight), (App)NoiseCodec.CODEC.fieldOf("noise").forGetter(TerrainNoise::noise)).apply((Applicative)instance, TerrainNoise::new));
    private static final double MIN_NOISE = 0.0196078431372549;
    private final Holder<TerrainType> type;
    private final float weight;
    private final Module noise;

    public TerrainNoise(Holder<TerrainType> type, float weight, Module noise) {
        this.type = type;
        this.weight = weight;
        this.noise = (double)noise.minValue() < 0.0196078431372549 ? noise.bias(0.0196078431372549).clamp(0.0, 1.0) : noise;
    }

    @Override
    public TerrainNoise withSeed(long seed) {
        Module heightmap = this.withSeed(seed, this.noise(), Module.class);
        return new TerrainNoise(this.type, this.weight, heightmap);
    }

    @Override
    public float weight() {
        return this.weight;
    }

    public Holder<TerrainType> type() {
        return this.type;
    }

    public Terrain terrain() {
        return ((TerrainType)this.type().value()).getTerrain();
    }

    public Module noise() {
        return this.noise;
    }

    public String toString() {
        return "TerrainConfig{type=" + String.valueOf(this.type) + ", weight=" + this.weight + ", noise=" + String.valueOf(this.noise) + "}";
    }

    static {
        NoiseCodec.init();
    }
}

