/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.asset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terrano.engine.world.terrain.ITerrain;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.Terrano;
import com.terrano.mod.data.codec.LazyCodec;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;

public class TerrainType {
    public static final TerrainType NONE = new TerrainType("none", com.terrano.engine.world.terrain.TerrainType.NONE);
    public static final Codec<TerrainType> DIRECT = LazyCodec.record(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(TerrainType::getName), (App)Codec.STRING.fieldOf("parent").xmap(TerrainType::forName, Terrain::getName).forGetter(TerrainType::getParentType)).apply((Applicative)instance, TerrainType::new));
    public static final Codec<Holder<TerrainType>> CODEC = LazyCodec.of(() -> RegistryFileCodec.create((ResourceKey)((ResourceKey)Terrano.TERRAIN_TYPES.get()), DIRECT));
    private final String name;
    private final Terrain parentType;
    private final Terrain terrain;

    public TerrainType(String name, Terrain type) {
        this.name = name;
        this.parentType = type;
        this.terrain = TerrainType.getOrCreate(name, type);
    }

    public String getName() {
        return this.name;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public Terrain getParentType() {
        return this.parentType;
    }

    private static Terrain forName(String name) {
        Terrain terrain = com.terrano.engine.world.terrain.TerrainType.get(name);
        return terrain != null ? terrain : com.terrano.engine.world.terrain.TerrainType.NONE;
    }

    private static Terrain getOrCreate(String name, Terrain parent) {
        Terrain existing = com.terrano.engine.world.terrain.TerrainType.get(name);
        if (existing != null) {
            return existing;
        }
        if (parent.getName().equals(name)) {
            return parent;
        }
        Terrano.LOG.debug("Terrain '{}' not found, using parent '{}'", (Object)name, (Object)parent.getName());
        return parent;
    }

    public static TerrainType of(Terrain terrain) {
        Terrain parent;
        ITerrain delegate = terrain.getDelegate();
        if (delegate instanceof Terrain && (parent = (Terrain)delegate) != terrain) {
            return new TerrainType(terrain.getName(), parent);
        }
        return new TerrainType(terrain.getName(), terrain);
    }
}

