/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.Seeds;
import com.terrano.mod.worldgen.biome.decorator.FeatureDecorator;
import com.terrano.mod.worldgen.biome.decorator.SurfaceDecorator;
import com.terrano.mod.worldgen.biome.surface.Surface;
import com.terrano.mod.worldgen.cave.NoiseCaveGenerator;
import com.terrano.mod.worldgen.terrain.TerrainData;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;

public class BiomeGenerator {
    private final SurfaceDecorator surfaceDecorator;
    private final FeatureDecorator featureDecorator;
    private final NoiseCaveGenerator noiseCaveGenerator;

    public BiomeGenerator(RegistryAccess access) {
        this.surfaceDecorator = new SurfaceDecorator();
        this.featureDecorator = new FeatureDecorator(access);
        this.noiseCaveGenerator = new NoiseCaveGenerator(access);
    }

    public BiomeGenerator(BiomeGenerator other) {
        this.surfaceDecorator = other.surfaceDecorator;
        this.featureDecorator = other.featureDecorator;
        this.noiseCaveGenerator = new NoiseCaveGenerator(other.noiseCaveGenerator);
    }

    public void surface(ChunkAccess chunk, WorldGenRegion region, RandomState state, Generator generator) {
        this.surfaceDecorator.decorate(chunk, region, generator, state);
        this.surfaceDecorator.decoratePost(chunk, region, generator);
        int seed = Seeds.get(region.getSeed());
        TerrainData terrainData = generator.getChunkData(seed, chunk.getPos());
        Surface.applyBiomeSurface(chunk, region, terrainData, generator);
    }

    public void carve(long seed, ChunkAccess chunk, WorldGenRegion region, BiomeManager biomes, GenerationStep.Carving step, Generator generator) {
        this.noiseCaveGenerator.carve((int)seed, chunk, generator);
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel region, StructureManager structures, Generator generator) {
        int seed = Seeds.get(region.getSeed());
        CompletableFuture<TerrainData> terrain = generator.getChunkDataAsync(seed, chunk.getPos());
        this.featureDecorator.decorate(chunk, region, structures, terrain, generator);
        this.noiseCaveGenerator.decorate(seed, chunk, region, generator);
        Surface.smoothWater(chunk, region, terrain.join());
        Surface.applyPost(chunk, terrain.join(), generator);
    }
}

