/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.terrano.engine.world.biome.type.BiomeType;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.util.storage.WeightMap;
import com.terrano.mod.worldgen.biome.IBiomeSampler;
import com.terrano.mod.worldgen.biome.util.BiomeMapManager;
import com.terrano.mod.worldgen.noise.INoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseLevels;
import com.terrano.mod.worldgen.noise.climate.ClimateSample;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeSampler
extends IBiomeSampler.Sampler
implements IBiomeSampler {
    protected final BiomeMapManager biomeMapManager;
    protected final INoiseGenerator noiseGenerator;
    protected final float beachSize = 0.025f;
    protected final float lowlandsMax;
    protected final float midlandsMax;
    protected final float highlandsMax;

    public BiomeSampler(INoiseGenerator noiseGenerator, BiomeMapManager biomeMapManager) {
        super(noiseGenerator);
        this.biomeMapManager = biomeMapManager;
        this.noiseGenerator = noiseGenerator;
        NoiseLevels levels = noiseGenerator.getLevels();
        float landStart = levels.heightMin;
        float landEnd = levels.heightMin + levels.baseRange + levels.heightRange;
        float landRange = landEnd - landStart;
        this.lowlandsMax = landStart + landRange * 0.2f;
        this.midlandsMax = landStart + landRange * 0.45f;
        this.highlandsMax = landStart + landRange * 0.65f;
        System.out.println("[Terrano] BiomeSampler height thresholds (noise space):");
        System.out.println("  landStart=" + landStart + " lowlands<" + this.lowlandsMax + " midlands<" + this.midlandsMax + " highlands<" + this.highlandsMax);
    }

    public Holder<Biome> sampleBiome(int seed, int x, int z) {
        ClimateSample sample = this.getSample(seed, x, z);
        Holder<Biome> oceanOrBeach = this.getOceanOrBeachBiome(sample);
        if (oceanOrBeach != null) {
            return oceanOrBeach;
        }
        Holder<Biome> river = this.getRiverBiome(sample);
        if (river != null) {
            return river;
        }
        return this.getTerrainAwareBiome(sample);
    }

    protected Holder<Biome> getTerrainAwareBiome(ClimateSample sample) {
        float height = sample.heightNoise;
        Terrain terrainType = sample.terrainType;
        BiomeType climate = sample.climateType;
        float biomeNoise = sample.biomeNoise;
        HeightCategory category = this.getHeightCategory(height, terrainType);
        return switch (category.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> this.getMountainBiome(climate, biomeNoise, height);
            case 2 -> this.getHighlandBiome(climate, biomeNoise);
            case 1 -> this.getMidlandBiome(climate, biomeNoise);
            case 0 -> this.getLowlandBiome(climate, biomeNoise);
        };
    }

    protected HeightCategory getHeightCategory(float height, Terrain terrain) {
        if (terrain != null) {
            String name = terrain.getName().toLowerCase();
            if (name.contains("mountain") || name.contains("volcano") || name.contains("ridge") || name.contains("dolomite")) {
                if (height > this.midlandsMax) {
                    return HeightCategory.MOUNTAIN_PEAKS;
                }
                return HeightCategory.HIGHLANDS;
            }
            if (name.contains("plateau") || name.contains("torridonian") || name.contains("badlands")) {
                if (height > this.highlandsMax) {
                    return HeightCategory.MOUNTAIN_PEAKS;
                }
                return HeightCategory.HIGHLANDS;
            }
        }
        if (height > this.highlandsMax) {
            return HeightCategory.MOUNTAIN_PEAKS;
        }
        if (height > this.midlandsMax) {
            return HeightCategory.HIGHLANDS;
        }
        if (height > this.lowlandsMax) {
            return HeightCategory.MIDLANDS;
        }
        return HeightCategory.LOWLANDS;
    }

    protected Holder<Biome> getMountainBiome(BiomeType climate, float biomeNoise, float height) {
        return switch (climate) {
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FROZEN_PEAKS);
            case BiomeType.TAIGA -> {
                if (height > this.highlandsMax + 0.1f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.JAGGED_PEAKS);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SNOWY_SLOPES);
            }
            case BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.STONY_PEAKS);
            case BiomeType.DESERT -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.STONY_PEAKS);
            case BiomeType.SAVANNA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA);
            case BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SPARSE_JUNGLE);
            default -> biomeNoise < 0.4f ? this.biomeMapManager.get((ResourceKey<Biome>)Biomes.JAGGED_PEAKS) : (biomeNoise < 0.7f ? this.biomeMapManager.get((ResourceKey<Biome>)Biomes.GROVE) : this.biomeMapManager.get((ResourceKey<Biome>)Biomes.STONY_PEAKS));
        };
    }

    protected Holder<Biome> getHighlandBiome(BiomeType climate, float biomeNoise) {
        return switch (climate) {
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SNOWY_TAIGA);
            case BiomeType.TAIGA -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.OLD_GROWTH_SPRUCE_TAIGA);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.TAIGA);
            }
            case BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_HILLS);
            case BiomeType.STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_GRAVELLY_HILLS);
            case BiomeType.GRASSLAND -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.MEADOW);
            case BiomeType.TEMPERATE_FOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_FOREST);
            case BiomeType.TEMPERATE_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DARK_FOREST);
            case BiomeType.DESERT -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.BADLANDS);
            case BiomeType.SAVANNA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA);
            case BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SPARSE_JUNGLE);
            default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.WINDSWEPT_HILLS);
        };
    }

    protected Holder<Biome> getMidlandBiome(BiomeType climate, float biomeNoise) {
        return switch (climate) {
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SNOWY_PLAINS);
            case BiomeType.TAIGA -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.TAIGA);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.OLD_GROWTH_PINE_TAIGA);
            }
            case BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
            case BiomeType.STEPPE -> {
                if (biomeNoise < 0.3f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SUNFLOWER_PLAINS);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
            }
            case BiomeType.GRASSLAND -> {
                if (biomeNoise < 0.3f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
                }
                if (biomeNoise < 0.6f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FOREST);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FLOWER_FOREST);
            }
            case BiomeType.TEMPERATE_FOREST -> {
                if (biomeNoise < 0.3f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FOREST);
                }
                if (biomeNoise < 0.6f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.BIRCH_FOREST);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.OLD_GROWTH_BIRCH_FOREST);
            }
            case BiomeType.TEMPERATE_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DARK_FOREST);
            case BiomeType.DESERT -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DESERT);
            case BiomeType.SAVANNA -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SAVANNA);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SAVANNA_PLATEAU);
            }
            case BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.JUNGLE);
            default -> this.getDefaultClimateBiome(biomeNoise, climate);
        };
    }

    protected Holder<Biome> getLowlandBiome(BiomeType climate, float biomeNoise) {
        return switch (climate) {
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SNOWY_PLAINS);
            case BiomeType.TAIGA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.TAIGA);
            case BiomeType.COLD_STEPPE, BiomeType.STEPPE -> {
                if (biomeNoise < 0.4f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SUNFLOWER_PLAINS);
            }
            case BiomeType.GRASSLAND -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.MEADOW);
            }
            case BiomeType.TEMPERATE_FOREST -> {
                if (biomeNoise < 0.3f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.PLAINS);
                }
                if (biomeNoise < 0.7f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FOREST);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SWAMP);
            }
            case BiomeType.TEMPERATE_RAINFOREST -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SWAMP);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
            }
            case BiomeType.DESERT -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DESERT);
            case BiomeType.SAVANNA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SAVANNA);
            case BiomeType.TROPICAL_RAINFOREST -> {
                if (biomeNoise < 0.5f) {
                    yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.JUNGLE);
                }
                yield this.biomeMapManager.get((ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE);
            }
            default -> this.getDefaultClimateBiome(biomeNoise, climate);
        };
    }

    protected Holder<Biome> getDefaultClimateBiome(float biomeNoise, BiomeType climate) {
        WeightMap<Holder<Biome>> map = this.biomeMapManager.getBiomeMap().get((Object)climate);
        if (map == null || map.isEmpty()) {
            return this.biomeMapManager.getBiomes().getHolderOrThrow(Biomes.PLAINS);
        }
        return map.getValue(biomeNoise);
    }

    protected Holder<Biome> getOceanOrBeachBiome(ClimateSample sample) {
        BiomeType biomeType = sample.climateType;
        if (sample.continentNoise <= 0.25f) {
            return this.getDeepOceanBiome(biomeType);
        }
        if (sample.continentNoise <= 0.5f) {
            return this.getShallowOceanBiome(biomeType);
        }
        if (sample.continentNoise <= 0.525f) {
            return this.getBeachBiome(biomeType);
        }
        return null;
    }

    protected Holder<Biome> getRiverBiome(ClimateSample sample) {
        if (sample.terrainType != null && (sample.terrainType.isRiver() || sample.terrainType.isLake()) && sample.riverNoise == 0.0f) {
            return sample.climateType == BiomeType.TUNDRA ? this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FROZEN_RIVER) : this.biomeMapManager.get((ResourceKey<Biome>)Biomes.RIVER);
        }
        return null;
    }

    protected Holder<Biome> getDeepOceanBiome(BiomeType biomeType) {
        return switch (biomeType) {
            case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN);
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN);
            case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DEEP_LUKEWARM_OCEAN);
            default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.DEEP_OCEAN);
        };
    }

    protected Holder<Biome> getShallowOceanBiome(BiomeType biomeType) {
        return switch (biomeType) {
            case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.COLD_OCEAN);
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.FROZEN_OCEAN);
            case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.LUKEWARM_OCEAN);
            default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.OCEAN);
        };
    }

    protected Holder<Biome> getBeachBiome(BiomeType biomeType) {
        return switch (biomeType) {
            case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.SNOWY_BEACH);
            case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.STONY_SHORE);
            default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.BEACH);
        };
    }

    protected static enum HeightCategory {
        LOWLANDS,
        MIDLANDS,
        HIGHLANDS,
        MOUNTAIN_PEAKS;

    }
}

