/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.terrano.mod.data.ModBiomes;
import com.terrano.mod.util.storage.WeightMap;
import com.terrano.mod.worldgen.biome.util.BiomeMapManager;
import com.terrano.mod.worldgen.cave.CaveType;
import com.terrano.noise.util.Noise;
import com.terrano.noise.util.NoiseUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class CaveBiomeSampler {
    public static final int OFFSET = 124897;
    protected final int scale;
    protected final float frequency;
    protected final Map<CaveType, WeightMap<Holder<Biome>>> typeMap = new EnumMap<CaveType, WeightMap<Holder<Biome>>>(CaveType.class);

    public CaveBiomeSampler(int scale, BiomeMapManager biomeMapManager) {
        Holder[] holderArray;
        this.scale = scale;
        this.frequency = 1.0f / (float)scale;
        Registry<Biome> biomes = biomeMapManager.getBiomes();
        Optional cave = biomes.getHolder((ResourceKey)ModBiomes.CAVE.get());
        if (cave.isPresent()) {
            Holder[] holderArray2 = new Holder[1];
            holderArray = holderArray2;
            holderArray2[0] = (Holder)cave.get();
        } else {
            holderArray = new Holder[]{};
        }
        Holder[] global = holderArray;
        Holder[] special = (Holder[])biomeMapManager.getBiomes().holders().toArray(Holder[]::new);
        this.typeMap.put(CaveType.GLOBAL, CaveBiomeSampler.create(global));
        this.typeMap.put(CaveType.UNIQUE, CaveBiomeSampler.create(special));
    }

    public CaveBiomeSampler(CaveBiomeSampler other) {
        this.scale = other.scale;
        this.frequency = 1.0f / (float)other.scale;
        this.typeMap.putAll(other.typeMap);
    }

    public Holder<Biome> getUnderGroundBiome(int seed, int x, int z, CaveType type) {
        float noise = CaveBiomeSampler.sample(seed + 124897, x, z, this.frequency);
        return this.typeMap.get((Object)type).getValue(noise);
    }

    protected static float sample(int seed, int x, int z, float frequency) {
        float nx = (float)x * frequency;
        float nz = (float)z * frequency;
        float noise = (1.0f + Noise.singleSimplex(nx, nz, seed)) * 0.5f;
        return NoiseUtil.clamp(noise, 0.0f, 1.0f);
    }

    protected static WeightMap<Holder<Biome>> create(Holder<Biome>[] biomes) {
        float[] weights = new float[biomes.length];
        Arrays.fill(weights, 1.0f);
        return new WeightMap<Holder<Biome>>(biomes, weights);
    }
}

