/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.terrano.mod.worldgen.noise.INoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseLevels;
import com.terrano.mod.worldgen.noise.climate.ClimateNoise;
import com.terrano.mod.worldgen.noise.climate.ClimateSample;

public interface IBiomeSampler {
    public ClimateSample getSample(int var1, int var2, int var3);

    public float getShape(int var1, int var2, int var3);

    public void sample(int var1, int var2, int var3, ClimateSample var4);

    public static ClimateNoise createClimate(INoiseGenerator generator) {
        if (generator == null) {
            return null;
        }
        return new ClimateNoise(generator.getContinent().getContext());
    }

    public static class Sampler
    implements IBiomeSampler {
        protected final NoiseLevels levels;
        protected final ClimateNoise climateNoise;
        protected final INoiseGenerator noiseGenerator;
        protected final ThreadLocal<ClimateSample> localSample = ThreadLocal.withInitial(ClimateSample::new);

        public Sampler(INoiseGenerator noiseGenerator) {
            this.levels = noiseGenerator.getLevels();
            this.climateNoise = IBiomeSampler.createClimate(noiseGenerator);
            this.noiseGenerator = noiseGenerator;
        }

        public ClimateSample getSample() {
            return this.localSample.get().reset();
        }

        public INoiseGenerator getNoiseGenerator() {
            return this.noiseGenerator;
        }

        @Override
        public ClimateSample getSample(int seed, int x, int z) {
            ClimateSample sample = this.localSample.get().reset();
            this.noiseGenerator.sample(seed, x, z, sample);
            float px = (float)x * this.levels.frequency;
            float pz = (float)z * this.levels.frequency;
            this.climateNoise.sample(seed, px, pz, sample);
            return sample;
        }

        @Override
        public float getShape(int seed, int x, int z) {
            float px = (float)x * this.levels.frequency;
            float pz = (float)z * this.levels.frequency;
            ClimateSample sample = this.localSample.get().reset();
            this.climateNoise.sample(seed, px, pz, sample);
            return sample.biomeEdgeNoise;
        }

        @Override
        public void sample(int seed, int x, int z, ClimateSample sample) {
            this.noiseGenerator.sample(seed, x, z, sample);
            float px = (float)x * this.levels.frequency;
            float pz = (float)z * this.levels.frequency;
            this.climateNoise.sample(seed, px, pz, sample);
        }
    }
}

