/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.mojang.serialization.MapCodec;
import com.terrano.engine.util.pos.PosUtil;
import com.terrano.mod.Terrano;
import com.terrano.mod.util.storage.LongCache;
import com.terrano.mod.util.storage.LossyCache;
import com.terrano.mod.worldgen.biome.BiomeSampler;
import com.terrano.mod.worldgen.biome.CaveBiomeSampler;
import com.terrano.mod.worldgen.biome.SourceCodec;
import com.terrano.mod.worldgen.biome.util.BiomeMapManager;
import com.terrano.mod.worldgen.cave.CaveType;
import com.terrano.mod.worldgen.noise.INoiseGenerator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class Source
extends BiomeSource {
    public static final MapCodec<Source> CODEC = new SourceCodec();
    public static final Climate.Sampler NOOP_CLIMATE_SAMPLER = Climate.empty();
    protected int seed;
    protected volatile RegistryAccess registries;
    protected volatile Set<Holder<Biome>> possibleBiomes;
    protected volatile BiomeSampler biomeSampler;
    protected volatile BiomeMapManager biomeMapManager;
    protected volatile CaveBiomeSampler caveBiomeSampler;
    protected volatile INoiseGenerator noiseGenerator;
    protected volatile boolean initialized = false;
    protected final LongCache<Holder<Biome>> cache = LossyCache.concurrent(2048, Holder[]::new);

    public Source() {
        this.possibleBiomes = new ObjectLinkedOpenHashSet();
    }

    public Source(INoiseGenerator noise, RegistryAccess access) {
        this.initialize(noise, access);
    }

    public synchronized void initBiomes(RegistryAccess access) {
        if (this.possibleBiomes != null && !this.possibleBiomes.isEmpty()) {
            return;
        }
        this.registries = access;
        ObjectLinkedOpenHashSet allBiomes = new ObjectLinkedOpenHashSet();
        Registry biomeRegistry = access.registryOrThrow(Registries.BIOME);
        Optional overworldTag = biomeRegistry.getTag(BiomeTags.IS_OVERWORLD);
        if (overworldTag.isPresent()) {
            for (Holder biome : (HolderSet.Named)overworldTag.get()) {
                allBiomes.add(biome);
            }
            Terrano.LOG.info("initBiomes: Loaded {} overworld biomes from IS_OVERWORLD tag", (Object)allBiomes.size());
        } else {
            Terrano.LOG.warn("initBiomes: IS_OVERWORLD tag not found, loading ALL biomes");
            for (Map.Entry entry : biomeRegistry.entrySet()) {
                biomeRegistry.getHolder((ResourceKey)entry.getKey()).ifPresent(((Set)allBiomes)::add);
            }
        }
        this.possibleBiomes = allBiomes;
        Terrano.LOG.info("initBiomes: possibleBiomes = {}", (Object)allBiomes.size());
    }

    public synchronized void initialize(INoiseGenerator noise, RegistryAccess access) {
        if (this.initialized) {
            return;
        }
        this.registries = access;
        this.noiseGenerator = noise;
        this.biomeMapManager = new BiomeMapManager(access);
        ObjectLinkedOpenHashSet allBiomes = new ObjectLinkedOpenHashSet();
        allBiomes.addAll(this.biomeMapManager.getOverworldBiomes());
        Registry biomeRegistry = access.registryOrThrow(Registries.BIOME);
        Optional overworldTag = biomeRegistry.getTag(BiomeTags.IS_OVERWORLD);
        if (overworldTag.isPresent()) {
            int added = 0;
            for (Holder biome : (HolderSet.Named)overworldTag.get()) {
                if (!allBiomes.add(biome)) continue;
                ++added;
            }
            if (added > 0) {
                Terrano.LOG.info("initialize: Added {} extra vanilla biomes for structures", (Object)added);
            }
        } else {
            Terrano.LOG.warn("initialize: IS_OVERWORLD tag missing, adding ALL biomes");
            for (Map.Entry entry : biomeRegistry.entrySet()) {
                biomeRegistry.getHolder((ResourceKey)entry.getKey()).ifPresent(((Set)allBiomes)::add);
            }
        }
        this.possibleBiomes = allBiomes;
        this.biomeSampler = new BiomeSampler(noise, this.biomeMapManager);
        this.caveBiomeSampler = new CaveBiomeSampler(800, this.biomeMapManager);
        this.initialized = true;
        Terrano.LOG.info("Source fully initialized: {} possible biomes", (Object)allBiomes.size());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void withSeed(long seed) {
        this.seed = (int)seed;
    }

    public Set<Holder<Biome>> possibleBiomes() {
        return this.possibleBiomes;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.possibleBiomes.stream();
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler) {
        if (!this.initialized) {
            return null;
        }
        return this.cache.computeIfAbsent(this.seed, PosUtil.pack(x, z), this::compute);
    }

    public RegistryAccess getRegistries() {
        return this.registries;
    }

    public BiomeSampler getBiomeSampler() {
        return this.biomeSampler;
    }

    public CaveBiomeSampler getCaveBiomeSampler() {
        return this.caveBiomeSampler;
    }

    public Holder<Biome> getUnderGroundBiome(int seed, int x, int z, CaveType type) {
        if (!this.initialized) {
            return null;
        }
        return this.caveBiomeSampler.getUnderGroundBiome(this.seed + seed, x, z, type);
    }

    public Registry<Biome> getRegistry() {
        return this.biomeMapManager != null ? this.biomeMapManager.getBiomes() : null;
    }

    protected Holder<Biome> compute(int seed, long index) {
        if (!this.initialized) {
            return null;
        }
        int x = PosUtil.unpackLeft(index) << 2;
        int z = PosUtil.unpackRight(index) << 2;
        return this.biomeSampler.sampleBiome(seed, x, z);
    }
}

