/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.biome.Source;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;

public class SourceCodec
extends MapCodec<Source> {
    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.empty();
    }

    public <T> DataResult<Source> decode(DynamicOps<T> ops, MapLike<T> input) {
        Source source = new Source();
        if (ops instanceof RegistryOps) {
            RegistryOps registryOps = (RegistryOps)ops;
            RegistryAccess access = SourceCodec.tryGetRegistryAccess(registryOps);
            if (access != null) {
                Terrano.LOG.info("SourceCodec: Early biome init from RegistryOps");
                source.initBiomes(access);
            } else {
                Terrano.LOG.debug("SourceCodec: RegistryAccess not available yet");
            }
        }
        return DataResult.success((Object)((Object)source));
    }

    public <T> RecordBuilder<T> encode(Source source, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return prefix;
    }

    private static <T> RegistryAccess tryGetRegistryAccess(RegistryOps<T> registryOps) {
        try {
            for (Class<?> clazz = registryOps.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    RegistryAccess nested;
                    field.setAccessible(true);
                    Object value = field.get(registryOps);
                    if (value instanceof RegistryAccess) {
                        RegistryAccess access = (RegistryAccess)value;
                        return access;
                    }
                    if (value == null || SourceCodec.isPrimitive(value) || (nested = SourceCodec.findNested(value, 0)) == null) continue;
                    return nested;
                }
            }
        }
        catch (Exception e) {
            Terrano.LOG.debug("SourceCodec: Failed to extract RegistryAccess: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static RegistryAccess findNested(Object obj, int depth) {
        if (obj instanceof RegistryAccess) {
            RegistryAccess access = (RegistryAccess)obj;
            return access;
        }
        if (depth > 3) {
            return null;
        }
        try {
            for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    RegistryAccess nested;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value instanceof RegistryAccess) {
                        RegistryAccess access = (RegistryAccess)value;
                        return access;
                    }
                    if (value == null || SourceCodec.isPrimitive(value) || depth >= 3 || (nested = SourceCodec.findNested(value, depth + 1)) == null) continue;
                    return nested;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isPrimitive(Object obj) {
        return obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character || obj instanceof Enum || obj.getClass().isArray() || obj instanceof Collection || obj instanceof Map;
    }
}

