/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.biomes;

import com.terrano.mod.Terrano;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public record ModBiome(ResourceKey<Biome> key, Supplier<Biome> factory) {
    public Biome create() {
        return this.factory.get();
    }

    public static ModBiome of(String name, ResourceKey<Biome> parent, RegistryAccess access, Consumer<Biome.BiomeBuilder> modifier) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Terrano.location(name));
        Supplier<Biome> factory = ModBiome.copyFactory(parent, access, modifier);
        return new ModBiome((ResourceKey<Biome>)key, factory);
    }

    private static Supplier<Biome> copyFactory(ResourceKey<Biome> parent, RegistryAccess access, Consumer<Biome.BiomeBuilder> modifier) {
        return () -> {
            Biome.BiomeBuilder builder = ModBiome.builderOf(parent, access);
            modifier.accept(builder);
            return builder.build();
        };
    }

    private static Biome.BiomeBuilder builderOf(ResourceKey<Biome> parent, RegistryAccess access) {
        Registry registry = access.registryOrThrow(Registries.BIOME);
        Biome biome = (Biome)registry.get(parent);
        if (biome == null) {
            throw new IllegalStateException("Biome not found: " + String.valueOf(parent.location()));
        }
        Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
        Biome.ClimateSettings climateSettings = biome.getModifiedClimateSettings();
        builder.temperature(climateSettings.temperature());
        builder.downfall(climateSettings.downfall());
        builder.hasPrecipitation(biome.hasPrecipitation());
        builder.mobSpawnSettings(biome.getMobSettings());
        builder.specialEffects(biome.getSpecialEffects());
        builder.generationSettings(biome.getGenerationSettings());
        return builder;
    }

    public static Biome create(ResourceKey<Biome> parent, HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> carvers, Consumer<Biome.BiomeBuilder> modifier) {
        Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
        builder.temperature(0.8f);
        builder.downfall(0.4f);
        builder.hasPrecipitation(true);
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(placedFeatures, carvers);
        builder.generationSettings(genSettings.build());
        modifier.accept(builder);
        return builder.build();
    }
}

