/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.decorator;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.biome.decorator.PositionSampler;
import com.terrano.mod.worldgen.biome.decorator.VanillaDecorator;
import com.terrano.mod.worldgen.biome.vegetation.BiomeVegetationManager;
import com.terrano.mod.worldgen.biome.vegetation.VegetationFeatures;
import com.terrano.mod.worldgen.terrain.TerrainData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class FeatureDecorator {
    public static final GenerationStep.Decoration[] STAGES = GenerationStep.Decoration.values();
    private static final int MAX_DECORATION_STAGE = GenerationStep.Decoration.TOP_LAYER_MODIFICATION.ordinal();
    private final BiomeVegetationManager vegetation;
    private final Map<GenerationStep.Decoration, List<Holder<Structure>>> structures;
    private static final Set<ResourceLocation> NO_FLOWER_BIOMES = Set.of(Biomes.TAIGA.location(), Biomes.OLD_GROWTH_PINE_TAIGA.location(), Biomes.OLD_GROWTH_SPRUCE_TAIGA.location(), Biomes.SNOWY_TAIGA.location());
    private static final Set<String> FLOWER_KEYWORDS = Set.of("flower", "tulip", "dandelion", "poppy", "orchid", "allium", "azure_bluet", "azure", "oxeye", "cornflower", "lily_of_the_valley", "lilac", "rose_bush", "peony", "sunflower");
    private static final Set<String> GLOBAL_BLOCKED_FEATURES = Set.of("lake_lava_surface", "lake_lava_underground");

    public FeatureDecorator(RegistryAccess access) {
        this.vegetation = new BiomeVegetationManager(access);
        this.structures = VanillaDecorator.buildStructureMap(access);
    }

    public BiomeVegetationManager getVegetationManager() {
        return this.vegetation;
    }

    public List<Holder<Structure>> getStageStructures(int stage) {
        return this.structures.get(STAGES[stage]);
    }

    public HolderSet<PlacedFeature> getStageFeatures(int stage, Biome biome) {
        List stages = biome.getGenerationSettings().features();
        if (stage >= stages.size()) {
            return null;
        }
        return (HolderSet)stages.get(stage);
    }

    public boolean shouldSkipFeature(Holder<PlacedFeature> feature, Holder<Biome> biome) {
        ResourceKey featureKey = feature.unwrapKey().orElse(null);
        if (featureKey == null) {
            return false;
        }
        String featurePath = featureKey.location().getPath().toLowerCase();
        for (String blocked : GLOBAL_BLOCKED_FEATURES) {
            if (!featurePath.contains(blocked)) continue;
            return true;
        }
        ResourceKey biomeKey = biome.unwrapKey().orElse(null);
        if (biomeKey != null && NO_FLOWER_BIOMES.contains(biomeKey.location())) {
            for (String keyword : FLOWER_KEYWORDS) {
                if (!featurePath.contains(keyword)) continue;
                return true;
            }
        }
        return false;
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel level, StructureManager structures, CompletableFuture<TerrainData> terrain, Generator generator) {
        BlockPos origin = FeatureDecorator.getOrigin(level, chunk);
        Holder biome = level.getBiome(origin);
        WorldgenRandom random = FeatureDecorator.getRandom(level.getSeed());
        long seed = random.setDecorationSeed(level.getSeed(), origin.getX(), origin.getZ());
        this.decoratePre(seed, origin, (Holder<Biome>)biome, chunk, level, generator, random, structures);
        this.decorateVegetation(seed, origin, (Holder<Biome>)biome, chunk, level, generator, random, terrain);
        this.decoratePost(seed, origin, (Holder<Biome>)biome, chunk, level, generator, random, structures);
    }

    private void decoratePre(long seed, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureManager structureManager) {
        VanillaDecorator.decorate(seed, 0, VegetationFeatures.STAGE - 1, origin, biome, chunk, level, generator, random, structureManager, this);
    }

    private void decoratePost(long seed, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureManager structureManager) {
        VanillaDecorator.decorate(seed, VegetationFeatures.STAGE + 1, MAX_DECORATION_STAGE, origin, biome, chunk, level, generator, random, structureManager, this);
    }

    private void decorateVegetation(long seed, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, CompletableFuture<TerrainData> terrain) {
        PositionSampler.placeVegetation(seed, origin, biome, chunk, level, generator, random, terrain, this);
    }

    private static BlockPos getOrigin(WorldGenLevel level, ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.getPos();
        SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)level.getMinSection());
        return sectionPos.origin();
    }

    private static WorldgenRandom getRandom(long seed) {
        return new WorldgenRandom((RandomSource)new LegacyRandomSource(seed));
    }
}

