/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.decorator;

import com.terrano.mod.util.MathUtil;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.asset.VegetationConfig;
import com.terrano.mod.worldgen.biome.decorator.FeatureDecorator;
import com.terrano.mod.worldgen.biome.decorator.SamplerContext;
import com.terrano.mod.worldgen.biome.vegetation.BiomeVegetation;
import com.terrano.mod.worldgen.biome.vegetation.VegetationFeatures;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateFeature;
import com.terrano.mod.worldgen.biome.vegetation.template.TreeReplacer;
import com.terrano.mod.worldgen.biome.viability.Viability;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.noise.util.NoiseUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class PositionSampler {
    protected static final float BORDER = 6.0f;
    public static final float SQUASH_FACTOR = 2.0f / NoiseUtil.sqrt(3.0f);

    public static void placeVegetation(long seed, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, CompletableFuture<TerrainData> terrain, FeatureDecorator decorator) {
        int offset = PositionSampler.placeTreesAndGrass(seed, chunk, level, terrain, generator, random, decorator);
        PositionSampler.placeOther(seed, offset, origin, biome, level, generator, random, decorator);
    }

    public static int placeTreesAndGrass(long seed, ChunkAccess chunk, WorldGenLevel level, CompletableFuture<TerrainData> terrain, Generator generator, WorldgenRandom random, FeatureDecorator decorator) {
        SamplerContext context = SamplerContext.get();
        context.chunk = chunk;
        context.region = level;
        context.random = random;
        context.generator = generator;
        context.viabilityContext.terrainData = terrain;
        context.viabilityContext.biomeSampler = generator.getSource().getBiomeSampler();
        PositionSampler.populate(context, decorator);
        int offset = 0;
        int x = chunk.getPos().getMinBlockX();
        int z = chunk.getPos().getMinBlockZ();
        for (int i = 0; i < context.biomeList.size(); ++i) {
            Holder<Biome> biome = context.biomeList.get(i);
            if (biome.is(BiomeTags.IS_RIVER)) continue;
            BiomeVegetation vegetation = decorator.getVegetationManager().getVegetation(biome);
            VegetationConfig config = vegetation.config;
            context.push((Biome)biome.value(), vegetation);
            if (config == VegetationConfig.NONE) {
                offset = PositionSampler.placeAt(seed, offset + i, x, z, context);
                continue;
            }
            offset = PositionSampler.sample(seed, offset + i, x, z, config.frequency(), config.jitter(), context, PositionSampler::placeAt);
            offset = PositionSampler.placeGrassAt(seed, offset + i, x, z, context);
        }
        return offset;
    }

    public static void placeOther(long seed, int offset, BlockPos origin, Holder<Biome> biome, WorldGenLevel level, Generator generator, WorldgenRandom random, FeatureDecorator decorator) {
        BiomeVegetation vegetation = decorator.getVegetationManager().getVegetation(biome);
        if (vegetation.features == VegetationFeatures.NONE) {
            return;
        }
        for (PlacedFeature other : vegetation.features.other()) {
            random.setFeatureSeed(seed, offset, VegetationFeatures.STAGE);
            if (!other.placeWithBiomeCheck(level, (ChunkGenerator)generator, (RandomSource)random, origin)) continue;
            ++offset;
        }
    }

    public static void populate(SamplerContext context, FeatureDecorator decorator) {
        ChunkAccess chunk = context.chunk;
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int x = startX + dx;
                int z = startZ + dz;
                int y = context.getHeight(dx, dz);
                Holder<Biome> biome = context.getBiome(x, y, z);
                BiomeVegetation vegetation = decorator.getVegetationManager().getVegetation(biome);
                Viability viability = vegetation.config.viability();
                float value = 0.5f;
                try {
                    value = viability.getFitness(x, z, context.viabilityContext);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                context.viability.set(dx, dz, value);
                context.biomeList.add(biome);
            }
        }
    }

    public static <T> int sample(long seed, int offset, int x, int z, float freq, float jitter, T context, Sampler<T> sampler) {
        float freqX = freq;
        float freqZ = freq * SQUASH_FACTOR;
        int minX = NoiseUtil.floor(((float)x - 6.0f) * freqX);
        int minZ = NoiseUtil.floor(((float)z - 6.0f) * freqZ);
        int maxX = NoiseUtil.floor(((float)(x + 15) + 6.0f) * freqX);
        int maxZ = NoiseUtil.floor(((float)(z + 15) + 6.0f) * freqZ);
        return PositionSampler.sample(seed, offset, minX, minZ, maxX, maxZ, freqX, freqZ, jitter, context, sampler);
    }

    public static <T> int sample(long seed, int offset, int minX, int minZ, int maxX, int maxZ, float freqX, float freqZ, float jitter, T context, Sampler<T> sampler) {
        int cellSeed = (int)seed;
        for (int pz = minZ; pz <= maxZ; ++pz) {
            float ox = (float)(pz & 1) * 0.5f;
            for (int px = minX; px <= maxX; ++px) {
                int hash = MathUtil.hash(cellSeed, px, pz);
                float dx = MathUtil.randX(hash);
                float dz = MathUtil.randZ(hash);
                float sx = (float)px + ox + dx * jitter * 0.65f;
                float sz = (float)pz + dz * jitter;
                int posX = NoiseUtil.floor(sx / freqX);
                int posZ = NoiseUtil.floor(sz / freqZ);
                offset = sampler.sample(seed, offset, hash, posX, posZ, context);
            }
        }
        return offset;
    }

    private static int placeAt(long seed, int offset, int x, int z, SamplerContext context) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (chunkX != context.chunk.getPos().x || chunkZ != context.chunk.getPos().z) {
            return offset;
        }
        int y = context.chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (y <= context.generator.getSeaLevel()) {
            return offset;
        }
        context.pos.set(x, y, z);
        for (PlacedFeature feature : context.features.trees()) {
            context.random.setFeatureSeed(seed, offset, VegetationFeatures.STAGE);
            if (!feature.placeWithBiomeCheck(context.region, (ChunkGenerator)context.generator, (RandomSource)context.random, (BlockPos)context.pos)) continue;
            ++offset;
        }
        for (PlacedFeature feature : context.features.grass()) {
            context.random.setFeatureSeed(seed, offset, VegetationFeatures.STAGE);
            if (!feature.placeWithBiomeCheck(context.region, (ChunkGenerator)context.generator, (RandomSource)context.random, (BlockPos)context.pos)) continue;
            ++offset;
        }
        return offset;
    }

    private static int placeAt(long seed, int offset, int hash, int x, int z, SamplerContext context) {
        ResourceLocation templateName;
        TreeReplacer replacer;
        float noise;
        if (!PositionSampler.isFeatureChunk(x, z, context)) {
            return offset;
        }
        int y = context.chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (y <= context.generator.getSeaLevel()) {
            return offset;
        }
        context.pos.set(x, y, z);
        Holder biome = context.region.getBiome((BlockPos)context.pos);
        if (biome.value() != context.biome) {
            return offset;
        }
        float viability = context.viability.get(x & 0xF, z & 0xF);
        if (viability < (noise = (1.0f - context.vegetation.density()) * MathUtil.rand(hash))) {
            return offset;
        }
        ResourceKey biomeKey = biome.unwrapKey().orElse(null);
        if (biomeKey != null && (replacer = TreeReplacer.getInstance()).isLoaded() && (templateName = replacer.selectTemplate(biomeKey.location(), (RandomSource)context.random)) != null) {
            context.random.setFeatureSeed(seed, offset, VegetationFeatures.STAGE);
            if (TemplateFeature.placeTemplate(context.region, (BlockPos)context.pos, (RandomSource)context.random, templateName)) {
                return offset + 1;
            }
        }
        for (PlacedFeature feature : context.features.trees()) {
            context.random.setFeatureSeed(seed, offset, VegetationFeatures.STAGE);
            if (!feature.placeWithBiomeCheck(context.region, (ChunkGenerator)context.generator, (RandomSource)context.random, (BlockPos)context.pos)) continue;
            ++offset;
        }
        return offset;
    }

    private static int placeGrassAt(long seed, int offset, int x, int z, SamplerContext context) {
        WorldGenLevel region = context.region;
        Generator generator = context.generator;
        WorldgenRandom random = context.random;
        BlockPos.MutableBlockPos pos = context.pos.set(x, 0, z);
        int passes = 2;
        passes += NoiseUtil.floor(2.0f * (1.0f - context.maxViability));
        passes += NoiseUtil.floor(4.0f * context.terrainData().getRiver().get(8, 8));
        passes -= NoiseUtil.floor(5 * context.terrainData().getHeight(8, 8));
        passes = Math.max(2, passes);
        for (int i = 0; i < passes; ++i) {
            for (PlacedFeature feature : context.features.grass()) {
                random.setFeatureSeed(seed, offset + i, VegetationFeatures.STAGE);
                if (!feature.placeWithBiomeCheck(region, (ChunkGenerator)generator, (RandomSource)random, (BlockPos)pos)) continue;
                ++offset;
            }
        }
        return offset;
    }

    private static boolean isFeatureChunk(int x, int z, SamplerContext context) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return chunkX == context.chunk.getPos().x && chunkZ == context.chunk.getPos().z;
    }

    public static interface Sampler<T> {
        public int sample(long var1, int var3, int var4, int var5, int var6, T var7);
    }
}

