/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.decorator;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.Seeds;
import com.terrano.mod.worldgen.biome.surface.Surface;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.util.NoiseChunkUtil;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public class SurfaceDecorator {
    public void decorate(ChunkAccess chunk, WorldGenRegion region, Generator generator, RandomState state) {
        WorldGenerationContext context = new WorldGenerationContext((ChunkGenerator)generator, (LevelHeightAccessor)region);
        NoiseChunk noiseChunk = NoiseChunkUtil.getNoiseChunk(chunk, state, generator);
        Registry<Biome> biomes = generator.getSource().getRegistry();
        BiomeManager biomeManager = region.getBiomeManager();
        SurfaceSystem surface = state.surfaceSystem();
        SurfaceRules.RuleSource surfaceRules = ((NoiseGeneratorSettings)generator.getVanillaGen().getSettings().value()).surfaceRule();
        surface.buildSurface(state, biomeManager, biomes, false, context, chunk, noiseChunk, surfaceRules);
    }

    public void decoratePost(ChunkAccess chunk, WorldGenRegion region, Generator generator) {
        int seed = Seeds.get(region.getSeed());
        TerrainData chunkData = generator.getChunkData(seed, chunk.getPos());
        Surface.apply(chunkData, chunk, generator);
    }
}

