/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.decorator;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.biome.decorator.FeatureDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class VanillaDecorator {
    public static void decorate(long seed, int from, int to, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureManager structureManager, FeatureDecorator decorator) {
        for (int stage = from; stage <= to; ++stage) {
            List<Holder<Structure>> structures = decorator.getStageStructures(stage);
            HolderSet<PlacedFeature> features = decorator.getStageFeatures(stage, (Biome)biome.value());
            if (features == null) continue;
            VanillaDecorator.placeStructures(seed, stage, chunk, level, generator, random, structureManager, structures);
            VanillaDecorator.placeFeatures(seed, structures.size(), stage, origin, level, generator, random, features, biome, decorator);
        }
    }

    private static void placeStructures(long seed, int stage, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureManager structureManager, List<Holder<Structure>> structures) {
        ChunkPos chunkPos = chunk.getPos();
        SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)level.getMinSection());
        for (int structureIndex = 0; structureIndex < structures.size(); ++structureIndex) {
            random.setFeatureSeed(seed, structureIndex, stage);
            Holder<Structure> structure = structures.get(structureIndex);
            List starts = structureManager.startsForStructure(sectionPos, (Structure)structure.value());
            for (int startIndex = 0; startIndex < starts.size(); ++startIndex) {
                StructureStart start = (StructureStart)starts.get(startIndex);
                start.placeInChunk(level, structureManager, (ChunkGenerator)generator, (RandomSource)random, VanillaDecorator.getWritableArea(chunk), chunkPos);
            }
        }
    }

    private static void placeFeatures(long seed, int offset, int stage, BlockPos origin, WorldGenLevel level, Generator generator, WorldgenRandom random, HolderSet<PlacedFeature> features, Holder<Biome> biome, FeatureDecorator decorator) {
        for (int i = 0; i < features.size(); ++i) {
            Holder featureHolder = features.get(i);
            if (decorator.shouldSkipFeature((Holder<PlacedFeature>)featureHolder, biome)) {
                random.setFeatureSeed(seed, offset + i, stage);
                continue;
            }
            random.setFeatureSeed(seed, offset + i, stage);
            PlacedFeature feature = (PlacedFeature)featureHolder.value();
            feature.placeWithBiomeCheck(level, (ChunkGenerator)generator, (RandomSource)random, origin);
        }
    }

    public static Map<GenerationStep.Decoration, List<Holder<Structure>>> buildStructureMap(RegistryAccess access) {
        EnumMap<GenerationStep.Decoration, List<Holder<Structure>>> map = new EnumMap<GenerationStep.Decoration, List<Holder<Structure>>>(GenerationStep.Decoration.class);
        Registry registry = access.registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry entry : registry.entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Structure value = (Structure)entry.getValue();
            map.computeIfAbsent(value.step(), s -> new ArrayList()).add(registry.getHolderOrThrow(key));
        }
        for (GenerationStep.Decoration stage : FeatureDecorator.STAGES) {
            if (map.containsKey(stage)) continue;
            map.put(stage, Collections.emptyList());
        }
        return map;
    }

    private static BoundingBox getWritableArea(ChunkAccess chunkAccess) {
        ChunkPos chunkPos = chunkAccess.getPos();
        int minX = chunkPos.getMinBlockX();
        int minZ = chunkPos.getMinBlockZ();
        LevelHeightAccessor levelHeightAccessor = chunkAccess.getHeightAccessorForGeneration();
        int minY = levelHeightAccessor.getMinBuildHeight() + 1;
        int maxY = levelHeightAccessor.getMaxBuildHeight() - 1;
        return new BoundingBox(minX, minY, minZ, minX + 15, maxY, minZ + 15);
    }
}

