/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.surface;

import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.util.ChunkUtil;
import com.terrano.noise.util.NoiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;

public class Surface {
    protected static final TagKey<Block> ERODIBLE = BlockTags.DIRT;
    private static final BlockState GRASS = Blocks.GRASS_BLOCK.defaultBlockState();
    private static final BlockState DIRT = Blocks.DIRT.defaultBlockState();
    private static final BlockState STONE = Blocks.STONE.defaultBlockState();
    private static final BlockState GRAVEL = Blocks.GRAVEL.defaultBlockState();
    private static final BlockState COARSE_DIRT = Blocks.COARSE_DIRT.defaultBlockState();
    private static final float BASE_GEN_DEPTH = 256.0f;

    public static void apply(TerrainData terrainData, ChunkAccess chunk, ChunkGenerator generator) {
        float norm = Surface.calculateNorm(55.0f, generator.getGenDepth());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                BlockState solid;
                int y;
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (y < generator.getSeaLevel() || gradient < 0.65f || (solid = Surface.findSolid(pos.set(dx, y, dz), chunk)) == null) continue;
                int bottom = pos.getY();
                for (y = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, dx, dz); y > bottom; --y) {
                    chunk.setBlockState((BlockPos)pos.setY(y), solid, false);
                }
            }
        }
    }

    public static void applyPost(ChunkAccess chunk, TerrainData terrainData, ChunkGenerator generator) {
        float norm = Surface.calculateNorm(70.0f, generator.getGenDepth());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dx, dz) + 1;
                pos.set(dx, y, dz);
                BlockState state = chunk.getBlockState((BlockPos)pos);
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (gradient < 0.7f) {
                    if (state.getBlock() instanceof SnowLayerBlock) {
                        Surface.smoothSnow(pos, state, chunk, terrainData);
                    }
                } else {
                    if (state.isAir()) {
                        state = chunk.getBlockState((BlockPos)pos.setY(y - 1));
                    }
                    if (state.is(BlockTags.SNOW)) {
                        Surface.erodeSnow(pos, chunk);
                    }
                }
                Surface.smoothBiomeBorders(dx, dz, chunk, terrainData, generator);
            }
        }
    }

    private static float calculateNorm(float baseNorm, int genDepth) {
        return baseNorm * (256.0f / (float)genDepth);
    }

    private static void smoothBiomeBorders(int dx, int dz, ChunkAccess chunk, TerrainData terrainData, ChunkGenerator generator) {
        BlockState transitionState;
        if (!Surface.isChunkBorder(dx, dz)) {
            return;
        }
        int y = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, dx, dz);
        if (y < generator.getSeaLevel()) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(dx, y, dz);
        BlockState surfaceState = chunk.getBlockState((BlockPos)pos);
        if (!Surface.needsSmoothing(surfaceState)) {
            return;
        }
        float edgeNoise = Surface.getBiomeEdgeNoise(dx, dz, terrainData);
        if (edgeNoise > 0.3f && edgeNoise < 0.85f && (transitionState = Surface.getTransitionBlock(surfaceState, edgeNoise, dx, dz, y)) != null && !transitionState.equals(surfaceState)) {
            BlockState belowTransition;
            chunk.setBlockState((BlockPos)pos, transitionState, false);
            BlockState belowState = chunk.getBlockState((BlockPos)pos.setY(y - 1));
            if (Surface.needsSmoothing(belowState) && (belowTransition = Surface.getTransitionBlockBelow(transitionState)) != null) {
                chunk.setBlockState((BlockPos)pos, belowTransition, false);
            }
        }
    }

    private static boolean isChunkBorder(int dx, int dz) {
        return dx < 2 || dx > 13 || dz < 2 || dz > 13;
    }

    private static boolean needsSmoothing(BlockState state) {
        return state.is(BlockTags.SAND) || state.is(Blocks.TERRACOTTA) || state.is(Blocks.RED_SAND) || state.is(BlockTags.TERRACOTTA) || state.is(Blocks.GRAVEL) || state.is(Blocks.STONE) || state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.PODZOL) || state.is(Blocks.MYCELIUM);
    }

    private static float getBiomeEdgeNoise(int dx, int dz, TerrainData terrainData) {
        return terrainData.getGradient(dx, dz, 50.0f);
    }

    private static BlockState getTransitionBlock(BlockState current, float edgeNoise, int x, int z, int y) {
        int hash = x * 31 + z * 17 + y * 7;
        float rand = (float)(hash & 0xFF) / 255.0f;
        float blendFactor = (edgeNoise - 0.3f) / 0.55f;
        if (current.is(BlockTags.SAND)) {
            if (blendFactor + rand * 0.3f > 0.7f) {
                return GRAVEL;
            }
            if (blendFactor + rand * 0.3f > 0.5f) {
                return COARSE_DIRT;
            }
            return null;
        }
        if (current.is(Blocks.STONE)) {
            if (blendFactor + rand * 0.3f > 0.6f) {
                return GRAVEL;
            }
            if (blendFactor + rand * 0.3f > 0.4f) {
                return COARSE_DIRT;
            }
            return null;
        }
        if (current.is(BlockTags.TERRACOTTA) || current.is(Blocks.TERRACOTTA)) {
            if (blendFactor + rand * 0.3f > 0.65f) {
                return COARSE_DIRT;
            }
            if (blendFactor + rand * 0.3f > 0.45f) {
                return Blocks.BROWN_TERRACOTTA.defaultBlockState();
            }
            return null;
        }
        if (current.is(Blocks.GRASS_BLOCK) || current.is(Blocks.PODZOL)) {
            if (blendFactor + rand * 0.2f > 0.75f) {
                return COARSE_DIRT;
            }
            return null;
        }
        return null;
    }

    private static BlockState getTransitionBlockBelow(BlockState surfaceState) {
        if (surfaceState.is(Blocks.GRAVEL)) {
            return STONE;
        }
        if (surfaceState.is(Blocks.COARSE_DIRT)) {
            return DIRT;
        }
        return DIRT;
    }

    public static void smoothWater(ChunkAccess chunk, WorldGenLevel region, TerrainData terrainData) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = chunk.getPos().getMinBlockX();
        int minZ = chunk.getPos().getMinBlockZ();
        BlockState waterState = (BlockState)Blocks.WATER.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(2));
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                if (!Surface.isSmoothable(dx, dz, terrainData)) continue;
                int x = minX + dx;
                int z = minZ + dz;
                int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dx, dz);
                BlockState state = chunk.getBlockState((BlockPos)pos.set(x, y, z));
                if (!state.is(Blocks.WATER) || (Integer)state.getValue((Property)LiquidBlock.LEVEL) != 0 || !Surface.shouldSmooth(x, y, z, chunk, region, pos)) continue;
                chunk.setBlockState((BlockPos)pos.set(x, y, z), waterState, false);
            }
        }
    }

    protected static boolean shouldSmooth(int x, int y, int z, ChunkAccess chunk, WorldGenLevel region, BlockPos.MutableBlockPos pos) {
        int radius = 6;
        int radius2 = radius * radius;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                int d2 = dx * dx + dz * dz;
                if (d2 == 0 || d2 > radius2) continue;
                pos.set(x + dx, y, z + dz);
                ChunkAccess world = Surface.sameChunk((BlockPos)pos, chunk.getPos()) ? chunk : region;
                BlockState state = world.getBlockState((BlockPos)pos);
                if (!state.isAir()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isSmoothable(int x, int z, TerrainData terrainData) {
        float river = terrainData.getRiver().get(x, z);
        Terrain terrain = terrainData.getTerrain().get(x, z);
        return (terrain.isRiver() || terrain.isLake()) && river == 0.0f;
    }

    protected static void smoothSnow(BlockPos.MutableBlockPos pos, BlockState state, ChunkAccess chunk, TerrainData terrain) {
        float height = terrain.getHeight().get(pos.getX(), pos.getZ());
        float delta = height - (float)terrain.getLevels().getHeight(height);
        int layers = 1 + NoiseUtil.floor(delta * 7.9999f);
        state = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers));
        chunk.setBlockState((BlockPos)pos, state, false);
    }

    protected static void erodeSnow(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        chunk.setBlockState((BlockPos)pos, Blocks.AIR.defaultBlockState(), false);
        int y0 = pos.getY() - 1;
        int y1 = Math.max(pos.getY() - 15, 0);
        for (int y = y0; y > y1; --y) {
            pos.setY(y);
            BlockState state = chunk.getBlockState((BlockPos)pos);
            if (!Surface.isErodible(state)) {
                return;
            }
            chunk.setBlockState((BlockPos)pos, Blocks.STONE.defaultBlockState(), false);
        }
    }

    public static boolean isErodible(BlockState state) {
        return state.is(ERODIBLE) || state.is(BlockTags.SNOW);
    }

    protected static boolean sameChunk(BlockPos pos, ChunkPos chunk) {
        return pos.getX() >> 4 == chunk.x && pos.getZ() >> 4 == chunk.z;
    }

    protected static BlockState findSolid(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.getBlockState((BlockPos)pos);
        if (!Surface.isErodible(state)) {
            return null;
        }
        int bottom = Math.max(0, pos.getY() - 20);
        for (int y = pos.getY() - 1; y > bottom; --y) {
            state = chunk.getBlockState((BlockPos)pos.setY(y));
            if (Surface.isErodible(state)) continue;
            return state;
        }
        return null;
    }

    public static void applyBiomeSurface(ChunkAccess chunk, WorldGenRegion region, TerrainData terrainData, ChunkGenerator generator) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = chunk.getPos().getMinBlockX();
        int minZ = chunk.getPos().getMinBlockZ();
        int seaLevel = generator.getSeaLevel();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int wx = minX + dx;
                int wz = minZ + dz;
                int y = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, dx, dz);
                if (y < seaLevel - 5) continue;
                pos.set(wx, y, wz);
                Holder biome = region.getBiome((BlockPos)pos);
                ResourceKey biomeKey = biome.unwrapKey().orElse(null);
                if (biomeKey == null) continue;
                String loc = biomeKey.location().getPath();
                if (Surface.isDesertBiome(loc)) {
                    Surface.applyDesertSurface(chunk, dx, dz, y, wx, wz);
                    continue;
                }
                if (Surface.isBadlandsBiome(loc)) {
                    Surface.applyBadlandsSurface(chunk, dx, dz, y, wx, wz);
                    continue;
                }
                if (Surface.isBeachBiome(loc)) {
                    Surface.applyBeachNearDesert(chunk, dx, dz, y, wx, wz, (WorldGenLevel)region, seaLevel);
                    continue;
                }
                if (!Surface.isSwampBiome(loc)) continue;
                Surface.applySwampPuddles(chunk, dx, dz, y, wx, wz, seaLevel);
            }
        }
    }

    private static boolean isDesertBiome(String name) {
        return name.contains("desert");
    }

    private static boolean isBadlandsBiome(String name) {
        return name.contains("badlands") || name.contains("eroded");
    }

    private static boolean isBeachBiome(String name) {
        return name.contains("beach");
    }

    private static boolean isSwampBiome(String name) {
        return name.contains("swamp") || name.contains("mangrove");
    }

    private static void applyBeachNearDesert(ChunkAccess chunk, int dx, int dz, int surfaceY, int wx, int wz, WorldGenLevel region, int seaLevel) {
        int y;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        boolean nearDesert = false;
        int checkRadius = 16;
        for (int cdz = -checkRadius; cdz <= checkRadius && !nearDesert; cdz += 4) {
            for (int cdx = -checkRadius; cdx <= checkRadius && !nearDesert; cdx += 4) {
                checkPos.set(wx + cdx, surfaceY, wz + cdz);
                try {
                    Holder neighborBiome = region.getBiome((BlockPos)checkPos);
                    ResourceKey neighborKey = neighborBiome.unwrapKey().orElse(null);
                    if (neighborKey == null || !Surface.isDesertBiome(neighborKey.location().getPath())) continue;
                    nearDesert = true;
                    continue;
                }
                catch (Exception neighborBiome) {
                    // empty catch block
                }
            }
        }
        if (!nearDesert) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState sand = Blocks.SAND.defaultBlockState();
        BlockState sandstone = Blocks.SANDSTONE.defaultBlockState();
        for (int dy = 0; dy < 6 && (y = surfaceY - dy) >= 0; ++dy) {
            pos.set(dx, y, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.isAir() || current.is(Blocks.WATER) || !current.is(Blocks.GRASS_BLOCK) && !current.is(Blocks.DIRT) && !current.is(Blocks.COARSE_DIRT)) continue;
            if (dy < 4) {
                chunk.setBlockState((BlockPos)pos, sand, false);
                continue;
            }
            chunk.setBlockState((BlockPos)pos, sandstone, false);
        }
    }

    private static void applyDesertSurface(ChunkAccess chunk, int dx, int dz, int surfaceY, int wx, int wz) {
        int y;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState sand = Blocks.SAND.defaultBlockState();
        BlockState sandstone = Blocks.SANDSTONE.defaultBlockState();
        BlockState stone = Blocks.STONE.defaultBlockState();
        float n = ChunkUtil.valueNoise((float)wx * 0.04f, (float)wz * 0.04f, 99999);
        int sandDepth = 3 + Math.round(n * 4.0f);
        for (int dy = 0; dy < sandDepth + 4 && (y = surfaceY - dy) >= 0; ++dy) {
            pos.set(dx, y, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.isAir() || current.is(Blocks.WATER)) continue;
            if (dy < sandDepth) {
                chunk.setBlockState((BlockPos)pos, sand, false);
                continue;
            }
            if (dy >= sandDepth + 3) continue;
            chunk.setBlockState((BlockPos)pos, sandstone, false);
        }
    }

    private static void applyBadlandsSurface(ChunkAccess chunk, int dx, int dz, int surfaceY, int wx, int wz) {
        int y;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState terracotta = Blocks.TERRACOTTA.defaultBlockState();
        BlockState redSand = Blocks.RED_SAND.defaultBlockState();
        BlockState orangeTerracotta = Blocks.ORANGE_TERRACOTTA.defaultBlockState();
        BlockState yellowTerracotta = Blocks.YELLOW_TERRACOTTA.defaultBlockState();
        BlockState brownTerracotta = Blocks.BROWN_TERRACOTTA.defaultBlockState();
        for (int dy = 0; dy < 12 && (y = surfaceY - dy) >= 0; ++dy) {
            pos.set(dx, y, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.isAir() || current.is(Blocks.WATER)) continue;
            if (dy == 0) {
                chunk.setBlockState((BlockPos)pos, redSand, false);
                continue;
            }
            if (dy < 3) {
                chunk.setBlockState((BlockPos)pos, orangeTerracotta, false);
                continue;
            }
            int band = (y + 3) % 5;
            BlockState state = switch (band) {
                case 0 -> terracotta;
                case 1 -> orangeTerracotta;
                case 2 -> yellowTerracotta;
                case 3 -> brownTerracotta;
                default -> terracotta;
            };
            chunk.setBlockState((BlockPos)pos, state, false);
        }
    }

    private static void applySwampPuddles(ChunkAccess chunk, int dx, int dz, int surfaceY, int wx, int wz, int seaLevel) {
        int heightAboveSea = surfaceY - seaLevel;
        if (heightAboveSea > 8 || surfaceY < seaLevel) {
            return;
        }
        float maxWet = 1.0f - (float)heightAboveSea / 8.0f;
        maxWet = Math.max(0.0f, Math.min(1.0f, maxWet));
        float zoneNoise = ChunkUtil.valueNoise((float)wx * 0.03f, (float)wz * 0.03f, 11223);
        float puddleNoise = ChunkUtil.valueNoise((float)wx * 0.12f, (float)wz * 0.12f, 33445);
        float detailNoise = ChunkUtil.valueNoise((float)wx * 0.35f, (float)wz * 0.35f, 55667);
        float combined = zoneNoise * 0.4f + puddleNoise * 0.4f + detailNoise * 0.2f;
        float waterThreshold = 0.5f + (1.0f - maxWet) * 0.4f;
        float mudThreshold = waterThreshold - 0.12f;
        float lightMudThreshold = mudThreshold - 0.1f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (combined > waterThreshold && maxWet > 0.2f) {
            pos.set(dx, surfaceY, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (Surface.isSoilBlock(current)) {
                float depthNoise = ChunkUtil.valueNoise((float)wx * 0.08f, (float)wz * 0.08f, 99887);
                int maxDepth = 1 + Math.round(maxWet * 2.0f);
                int depth = 1 + Math.round(depthNoise * (float)(maxDepth - 1));
                depth = Math.min(depth, 3);
                if ((depth = Math.min(depth, heightAboveSea)) <= 0) {
                    depth = 1;
                }
                for (int dy = 0; dy < depth; ++dy) {
                    pos.set(dx, surfaceY - dy, dz);
                    BlockState blockAt = chunk.getBlockState((BlockPos)pos);
                    if (!Surface.isSoilBlock(blockAt) && !blockAt.isAir()) continue;
                    chunk.setBlockState((BlockPos)pos, Blocks.WATER.defaultBlockState(), false);
                }
                pos.set(dx, surfaceY - depth, dz);
                BlockState bottomBlock = chunk.getBlockState((BlockPos)pos);
                if (Surface.isSoilBlock(bottomBlock) || bottomBlock.is(Blocks.STONE)) {
                    float bottomNoise = ChunkUtil.valueNoise((float)wx * 0.21f, (float)wz * 0.21f, 77889);
                    if (bottomNoise < 0.35f) {
                        chunk.setBlockState((BlockPos)pos, Blocks.CLAY.defaultBlockState(), false);
                    } else {
                        chunk.setBlockState((BlockPos)pos, Blocks.MUD.defaultBlockState(), false);
                    }
                }
            }
        } else if (combined > mudThreshold) {
            pos.set(dx, surfaceY, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.is(Blocks.GRASS_BLOCK) || current.is(Blocks.DIRT)) {
                chunk.setBlockState((BlockPos)pos, Blocks.MUD.defaultBlockState(), false);
                pos.set(dx, surfaceY - 1, dz);
                BlockState below = chunk.getBlockState((BlockPos)pos);
                if (below.is(Blocks.DIRT)) {
                    chunk.setBlockState((BlockPos)pos, Blocks.MUD.defaultBlockState(), false);
                }
            }
        } else if (combined > lightMudThreshold) {
            float scatter;
            pos.set(dx, surfaceY, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.is(Blocks.GRASS_BLOCK) && (scatter = ChunkUtil.valueNoise((float)wx * 0.5f, (float)wz * 0.5f, 12345)) > 0.4f) {
                chunk.setBlockState((BlockPos)pos, Blocks.MUD.defaultBlockState(), false);
            }
        } else if (heightAboveSea <= 3) {
            float lowNoise;
            pos.set(dx, surfaceY, dz);
            BlockState current = chunk.getBlockState((BlockPos)pos);
            if (current.is(Blocks.GRASS_BLOCK) && (lowNoise = ChunkUtil.valueNoise((float)wx * 0.18f, (float)wz * 0.18f, 54321)) > 0.55f) {
                chunk.setBlockState((BlockPos)pos, Blocks.MUD.defaultBlockState(), false);
            }
        }
    }

    private static boolean isSoilBlock(BlockState state) {
        return state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.MUD) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.PODZOL) || state.is(Blocks.MYCELIUM);
    }
}

