/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.util;

import com.terrano.engine.world.biome.type.BiomeType;
import com.terrano.mod.Terrano;
import com.terrano.mod.util.storage.WeightMap;
import com.terrano.mod.worldgen.asset.ClimateType;
import com.terrano.mod.worldgen.biome.util.BiomeUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeMapManager {
    private static final BiomeType[] TYPES = BiomeType.values();
    private static final BiomeTypeHolder[] HOLDERS = (BiomeTypeHolder[])Stream.of(TYPES).map(BiomeTypeHolder::new).toArray(BiomeTypeHolder[]::new);
    private final Registry<Biome> biomes;
    private final Registry<ClimateType> climateTypes;
    private final List<Holder<Biome>> overworldBiomes;
    private final Map<BiomeType, WeightMap<Holder<Biome>>> biomeMap;

    public BiomeMapManager(RegistryAccess access) {
        this.biomes = access.registryOrThrow(Registries.BIOME);
        this.climateTypes = access.registryOrThrow((ResourceKey)Terrano.CLIMATES.get());
        this.overworldBiomes = BiomeMapManager.getOverworldBiomes(this.biomes, this.climateTypes);
        this.biomeMap = this.buildBiomeMap();
    }

    public Holder<Biome> get(ResourceKey<Biome> key) {
        return this.biomes.getHolderOrThrow(key);
    }

    public Registry<Biome> getBiomes() {
        return this.biomes;
    }

    public List<Holder<Biome>> getOverworldBiomes() {
        return this.overworldBiomes;
    }

    public Map<BiomeType, WeightMap<Holder<Biome>>> getBiomeMap() {
        return this.biomeMap;
    }

    private Map<BiomeType, WeightMap<Holder<Biome>>> buildBiomeMap() {
        Map<BiomeType, Object2FloatMap<Holder<Biome>>> map = this.getWeightsMap();
        EnumMap<BiomeType, WeightMap<Holder<Biome>>> result = new EnumMap<BiomeType, WeightMap<Holder<Biome>>>(BiomeType.class);
        for (Map.Entry<BiomeType, Object2FloatMap<Holder<Biome>>> entry : map.entrySet()) {
            Holder[] values = (Holder[])entry.getValue().keySet().toArray(Holder[]::new);
            float[] weights = entry.getValue().values().toFloatArray();
            result.put(entry.getKey(), new WeightMap<Holder>(values, weights));
        }
        return result;
    }

    private Map<BiomeType, Object2FloatMap<Holder<Biome>>> getWeightsMap() {
        HashMap<BiomeType, Object2FloatMap<Holder<Biome>>> map = new HashMap<BiomeType, Object2FloatMap<Holder<Biome>>>();
        ObjectOpenHashSet registered = new ObjectOpenHashSet();
        for (BiomeTypeHolder typeHolder : HOLDERS) {
            ClimateType biomeType = (ClimateType)this.climateTypes.get(typeHolder.name);
            if (biomeType == null) {
                map.put(typeHolder.type(), BiomeMapManager.newMutableWeightMap());
                continue;
            }
            Object2FloatMap<Holder<Biome>> typeMap = BiomeMapManager.getBiomeWeights(biomeType, this.biomes, arg_0 -> ((ObjectOpenHashSet)registered).add(arg_0));
            map.put(typeHolder.type(), typeMap);
        }
        for (Holder holder : this.overworldBiomes) {
            BiomeType type;
            if (registered.contains((Object)holder) || (type = BiomeUtil.getType((Holder<Biome>)holder)) == null) continue;
            map.computeIfAbsent(type, t -> new Object2FloatLinkedOpenHashMap()).put((Object)holder, 1.0f);
        }
        return map;
    }

    private static Object2FloatMap<Holder<Biome>> getBiomeWeights(ClimateType type, Registry<Biome> biomes, Consumer<Holder<Biome>> registered) {
        Object2FloatMap<Holder<Biome>> map = BiomeMapManager.newMutableWeightMap();
        for (Object2FloatMap.Entry entry : type.getWeights().object2FloatEntrySet()) {
            Optional optBiome = biomes.getOptional((ResourceLocation)entry.getKey());
            if (optBiome.isEmpty()) continue;
            ResourceKey key = (ResourceKey)biomes.getResourceKey((Object)((Biome)optBiome.get())).orElseThrow();
            Holder.Reference biome = biomes.getHolderOrThrow(key);
            map.put((Object)biome, entry.getFloatValue());
            registered.accept((Holder<Biome>)biome);
        }
        return map;
    }

    private static List<Holder<Biome>> getOverworldBiomes(Registry<Biome> biomes, Registry<ClimateType> biomeTypes) {
        List<Holder<Biome>> list = BiomeUtil.getOverworldBiomes(biomes);
        ObjectOpenHashSet added = new ObjectOpenHashSet(list);
        for (ClimateType type : biomeTypes) {
            for (ResourceLocation name : type.getWeights().keySet()) {
                Holder.Reference biome;
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)name);
                Optional holder = biomes.getHolder(key);
                if (holder.isEmpty() || !added.add((Object)(biome = (Holder.Reference)holder.get()))) continue;
                list.add((Holder<Biome>)biome);
            }
        }
        list.sort(BiomeUtil.BIOME_SORTER);
        return list;
    }

    private static Object2FloatMap<Holder<Biome>> newMutableWeightMap() {
        return new Object2FloatLinkedOpenHashMap();
    }

    private record BiomeTypeHolder(BiomeType type, ResourceLocation name) {
        public BiomeTypeHolder(BiomeType type) {
            this(type, Terrano.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

