/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.util;

import com.terrano.engine.world.biome.type.BiomeType;
import com.terrano.mod.Terrano;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;

public class BiomeUtil {
    private static final Map<BiomeType, ResourceLocation> TYPE_NAMES = new EnumMap<BiomeType, ResourceLocation>(BiomeType.class);
    private static final Comparator<ResourceKey<?>> KEY_COMPARATOR = Comparator.comparing(ResourceKey::location);
    public static Comparator<Holder<Biome>> BIOME_SORTER = (o1, o2) -> {
        ResourceKey k1 = (ResourceKey)o1.unwrapKey().orElseThrow();
        ResourceKey k2 = (ResourceKey)o2.unwrapKey().orElseThrow();
        Objects.requireNonNull(k1);
        Objects.requireNonNull(k2);
        return KEY_COMPARATOR.compare(k1, k2);
    };

    public static ResourceLocation getRegistryName(BiomeType type) {
        return TYPE_NAMES.get((Object)type);
    }

    public static List<Holder<Biome>> getOverworldBiomes(RegistryAccess access) {
        return BiomeUtil.getOverworldBiomes((Registry<Biome>)access.registryOrThrow(Registries.BIOME));
    }

    public static List<Holder<Biome>> getOverworldBiomes(Registry<Biome> biomes) {
        ObjectArrayList holders = new ObjectArrayList();
        for (Holder biome : biomes.asHolderIdMap()) {
            if (!biome.is(BiomeTags.IS_OVERWORLD)) continue;
            holders.add((Object)biome);
        }
        holders.sort(BIOME_SORTER);
        return holders;
    }

    public static BiomeType getType(Holder<Biome> biome) {
        if (biome.is(BiomeTags.IS_BADLANDS) || biome.is(BiomeTags.HAS_VILLAGE_DESERT)) {
            return BiomeType.DESERT;
        }
        if (biome.is(BiomeTags.IS_SAVANNA)) {
            return BiomeType.SAVANNA;
        }
        if (biome.is(BiomeTags.IS_JUNGLE)) {
            return BiomeType.TROPICAL_RAINFOREST;
        }
        if (biome.is(BiomeTags.IS_TAIGA)) {
            return BiomeUtil.getByTemp(biome, BiomeType.TUNDRA, BiomeType.TAIGA);
        }
        if (biome.is(BiomeTags.IS_FOREST)) {
            return BiomeUtil.getByRain(biome, BiomeType.TUNDRA, BiomeType.TEMPERATE_RAINFOREST, BiomeType.TEMPERATE_FOREST);
        }
        return BiomeType.GRASSLAND;
    }

    public static BiomeType getByRain(Holder<Biome> biome, BiomeType frozen, BiomeType wetter, BiomeType dryer) {
        if (biome.is(BiomeTags.IS_TAIGA) || biome.is(BiomeTags.SNOW_GOLEM_MELTS)) {
            // empty if block
        }
        Biome b = (Biome)biome.value();
        if (biome.is(BiomeTags.SNOW_GOLEM_MELTS)) {
            return frozen;
        }
        if (biome.is(BiomeTags.IS_JUNGLE) || biome.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
            return wetter;
        }
        return dryer;
    }

    public static BiomeType getByTemp(Holder<Biome> biome, BiomeType colder, BiomeType warmer) {
        if (biome.is(BiomeTags.SNOW_GOLEM_MELTS) || biome.is(BiomeTags.IS_TAIGA) && !biome.is(BiomeTags.IS_JUNGLE)) {
            return colder;
        }
        return warmer;
    }

    public static BiomeType getByTemp(Holder<Biome> biome, BiomeType cold, BiomeType temperate, BiomeType hot) {
        if (biome.is(BiomeTags.SNOW_GOLEM_MELTS)) {
            return cold;
        }
        if (biome.is(BiomeTags.IS_BADLANDS) || biome.is(BiomeTags.HAS_VILLAGE_DESERT) || biome.is(BiomeTags.IS_SAVANNA)) {
            return hot;
        }
        return temperate;
    }

    static {
        for (BiomeType type : BiomeType.values()) {
            TYPE_NAMES.put(type, Terrano.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

