/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation;

import com.terrano.mod.Terrano;
import com.terrano.mod.data.ModVegetations;
import com.terrano.mod.worldgen.asset.VegetationConfig;
import com.terrano.mod.worldgen.biome.vegetation.BiomeVegetation;
import com.terrano.mod.worldgen.biome.vegetation.VegetationFeatures;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.biome.Biome;

public class BiomeVegetationManager {
    private final RegistryAccess access;
    private final VegetationConfig[] configs;
    private final Map<Holder<Biome>, BiomeVegetation> vegetation = new ConcurrentHashMap<Holder<Biome>, BiomeVegetation>();

    public BiomeVegetationManager(RegistryAccess access) {
        this.access = access;
        VegetationConfig[] loaded = Terrano.VEGETATIONS.entries(access, VegetationConfig[]::new);
        if (loaded.length == 0) {
            Terrano.LOG.warn("Vegetation registry empty, using fallback configs");
            loaded = ModVegetations.Factory.getDefaults(access);
        }
        this.configs = loaded;
        Terrano.LOG.info("BiomeVegetationManager: {} vegetation configs", (Object)this.configs.length);
    }

    public BiomeVegetation getVegetation(Holder<Biome> biome) {
        return this.vegetation.computeIfAbsent(biome, this::compute);
    }

    private BiomeVegetation compute(Holder<Biome> biome) {
        VegetationConfig config = BiomeVegetationManager.getConfig(biome, this.configs);
        VegetationFeatures features = VegetationFeatures.create((Biome)biome.value(), this.access, config);
        return new BiomeVegetation(config, features);
    }

    private static VegetationConfig getConfig(Holder<Biome> biome, VegetationConfig[] configs) {
        for (VegetationConfig config : configs) {
            try {
                if (config.biomes() == null || !biome.is(config.biomes())) continue;
                return config;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VegetationConfig.NONE;
    }
}

