/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation;

import com.google.common.collect.ImmutableSet;
import com.terrano.mod.Terrano;
import com.terrano.mod.util.ReflectionUtil;
import com.terrano.mod.worldgen.asset.VegetationConfig;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateFeature;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateFeatureConfig;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateManager;
import com.terrano.mod.worldgen.biome.vegetation.template.TreeReplacer;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class VegetationFeatures {
    public static VegetationFeatures NONE = new VegetationFeatures();
    public static final int STAGE = GenerationStep.Decoration.VEGETAL_DECORATION.ordinal();
    private static final MethodHandle FEATURE_GETTER = ReflectionUtil.field(PlacedFeature.class, Holder.class, new String[0]);
    private static final MethodHandle PLACEMENTS_GETTER = ReflectionUtil.field(PlacedFeature.class, List.class, new String[0]);
    private static final Set<PlacementModifierType<?>> BIOME_CHECK = Set.of(PlacementModifierType.BIOME_FILTER);
    private static final Set<PlacementModifierType<?>> EXCLUSIONS = Set.of(PlacementModifierType.BIOME_FILTER, PlacementModifierType.COUNT, PlacementModifierType.COUNT_ON_EVERY_LAYER, PlacementModifierType.NOISE_BASED_COUNT, PlacementModifierType.NOISE_THRESHOLD_COUNT);
    private static final Set<PlacementModifierType<?>> TREE_EXCLUSIONS = ImmutableSet.builder().addAll(EXCLUSIONS).add((Object)PlacementModifierType.IN_SQUARE).build();
    protected static final String[] TREE_KEYWORDS = new String[]{"tree", "spruce", "oak", "birch", "pine", "dark_forest_vegetation"};
    protected static final String[] GRASS_KEYWORDS = new String[]{"grass"};
    private final PlacedFeature[] trees;
    private final PlacedFeature[] grass;
    private final PlacedFeature[] other;

    private VegetationFeatures() {
        this.trees = new PlacedFeature[0];
        this.grass = new PlacedFeature[0];
        this.other = new PlacedFeature[0];
    }

    public VegetationFeatures(List<PlacedFeature> trees, List<PlacedFeature> grass, List<PlacedFeature> other) {
        this.trees = (PlacedFeature[])trees.toArray(PlacedFeature[]::new);
        this.grass = (PlacedFeature[])grass.toArray(PlacedFeature[]::new);
        this.other = (PlacedFeature[])other.toArray(PlacedFeature[]::new);
    }

    public PlacedFeature[] trees() {
        return this.trees;
    }

    public PlacedFeature[] grass() {
        return this.grass;
    }

    public PlacedFeature[] other() {
        return this.other;
    }

    public static VegetationFeatures create(Biome biome, RegistryAccess access, VegetationConfig config) {
        ArrayList<PlacedFeature> trees = new ArrayList<PlacedFeature>();
        ArrayList<PlacedFeature> grass = new ArrayList<PlacedFeature>();
        ArrayList<PlacedFeature> other = new ArrayList<PlacedFeature>();
        boolean custom = config != VegetationConfig.NONE;
        List features = biome.getGenerationSettings().features();
        if (features.size() > STAGE) {
            HolderSet vegetation = (HolderSet)features.get(STAGE);
            Registry featureRegistry = access.registryOrThrow(Registries.PLACED_FEATURE);
            Registry biomeRegistry = access.registryOrThrow(Registries.BIOME);
            ResourceLocation biomeName = biomeRegistry.getKey((Object)biome);
            for (Holder feature : vegetation) {
                ResourceLocation featureKey = featureRegistry.getKey((Object)((PlacedFeature)feature.value()));
                if (featureKey == null) {
                    other.add((PlacedFeature)feature.value());
                    continue;
                }
                String path = featureKey.getPath();
                if (VegetationFeatures.matches(path, TREE_KEYWORDS)) {
                    PlacedFeature replacement = VegetationFeatures.tryReplaceTree((Holder<PlacedFeature>)feature, biomeName, custom);
                    if (replacement != null) {
                        trees.add(replacement);
                        continue;
                    }
                    trees.add(VegetationFeatures.unwrap((Holder<PlacedFeature>)feature, TREE_EXCLUSIONS, custom));
                    continue;
                }
                if (VegetationFeatures.matches(path, GRASS_KEYWORDS)) {
                    grass.add((PlacedFeature)feature.value());
                    continue;
                }
                other.add((PlacedFeature)feature.value());
            }
        }
        return new VegetationFeatures(trees, grass, other);
    }

    private static PlacedFeature tryReplaceTree(Holder<PlacedFeature> original, ResourceLocation biomeName, boolean custom) {
        TreeReplacer replacer = TreeReplacer.getInstance();
        if (!replacer.isLoaded() || biomeName == null) {
            return null;
        }
        List<TreeReplacer.TemplateEntry> templateEntries = replacer.getTemplatesForBiome(biomeName);
        if (templateEntries.isEmpty()) {
            return null;
        }
        TemplateManager manager = TemplateManager.getInstance();
        if (!manager.isLoaded()) {
            return null;
        }
        ResourceLocation defaultTemplate = null;
        for (TreeReplacer.TemplateEntry entry : templateEntries) {
            if (!manager.hasTemplate(entry.templateName())) continue;
            defaultTemplate = entry.templateName();
            break;
        }
        if (defaultTemplate == null) {
            return null;
        }
        try {
            TemplateFeatureConfig templateConfig = new TemplateFeatureConfig(defaultTemplate);
            Holder configuredHolder = Holder.direct((Object)new ConfiguredFeature((Feature)TemplateFeature.INSTANCE, (FeatureConfiguration)templateConfig));
            ArrayList placements = new ArrayList();
            return new PlacedFeature(configuredHolder, placements);
        }
        catch (Exception e) {
            Terrano.LOG.error("Failed to create template replacement for biome {}", (Object)biomeName, (Object)e);
            return null;
        }
    }

    protected static boolean matches(String name, String[] keywords) {
        for (String keyword : keywords) {
            if (!name.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static PlacedFeature unwrap(Holder<PlacedFeature> supplier, Set<PlacementModifierType<?>> exclusions, boolean custom) {
        if (!custom) {
            return (PlacedFeature)supplier.value();
        }
        try {
            PlacedFeature placed = (PlacedFeature)supplier.value();
            Holder<ConfiguredFeature<?, ?>> feature = VegetationFeatures.getFeature(placed);
            ArrayList<PlacementModifier> placements = new ArrayList<PlacementModifier>(VegetationFeatures.getPlacements(placed));
            placements.removeIf(placement -> exclusions.contains(placement.type()));
            return new PlacedFeature(feature, placements);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return (PlacedFeature)supplier.value();
        }
    }

    protected static Holder<ConfiguredFeature<?, ?>> getFeature(PlacedFeature feature) throws Throwable {
        return FEATURE_GETTER.invokeExact(feature);
    }

    protected static List<PlacementModifier> getPlacements(PlacedFeature feature) throws Throwable {
        return PLACEMENTS_GETTER.invokeExact(feature);
    }
}

