/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.terrano.mod.Terrano;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class TemplateConfig {
    private final ResourceLocation name;
    private final String type;
    private final List<ResourceLocation> structurePaths;
    private final int extendBase;
    private final boolean checkBounds;

    public TemplateConfig(ResourceLocation name, String type, List<ResourceLocation> structurePaths, int extendBase, boolean checkBounds) {
        this.name = name;
        this.type = type;
        this.structurePaths = structurePaths;
        this.extendBase = extendBase;
        this.checkBounds = checkBounds;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<ResourceLocation> getStructurePaths() {
        return this.structurePaths;
    }

    public int getExtendBase() {
        return this.extendBase;
    }

    public boolean shouldCheckBounds() {
        return this.checkBounds;
    }

    public static TemplateConfig parse(ResourceLocation id, JsonObject root) {
        String type = root.has("type") ? root.get("type").getAsString() : "tree";
        ResourceLocation name = root.has("name") ? ResourceLocation.parse((String)root.get("name").getAsString()) : id;
        ArrayList<ResourceLocation> paths = new ArrayList<ResourceLocation>();
        if (root.has("paths")) {
            for (JsonElement element : root.getAsJsonArray("paths")) {
                paths.add(ResourceLocation.parse((String)element.getAsString()));
            }
        }
        int extendBase = 0;
        boolean checkBounds = false;
        if (root.has("config")) {
            JsonObject config = root.getAsJsonObject("config");
            extendBase = config.has("extend_base") ? config.get("extend_base").getAsInt() : 0;
            checkBounds = config.has("check_bounds") && config.get("check_bounds").getAsBoolean();
        }
        return new TemplateConfig(name, type, paths, extendBase, checkBounds);
    }

    public static TemplateConfig load(ResourceLocation id, ResourceManager resourceManager) {
        block7: {
            TemplateConfig templateConfig;
            ResourceLocation jsonPath = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("templates/trees/" + id.getPath() + ".json"));
            Optional resource = resourceManager.getResource(jsonPath);
            if (!resource.isPresent()) break block7;
            InputStreamReader reader = new InputStreamReader(((Resource)resource.get()).open());
            try {
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                templateConfig = TemplateConfig.parse(id, root);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Terrano.LOG.error("Failed to load template config: {}", (Object)jsonPath, (Object)e);
                }
            }
            reader.close();
            return templateConfig;
        }
        return null;
    }
}

