/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation.template;

import com.mojang.serialization.Codec;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateConfig;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateFeatureConfig;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateManager;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplatePlacer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TemplateFeature
extends Feature<TemplateFeatureConfig> {
    public static final TemplateFeature INSTANCE = new TemplateFeature(TemplateFeatureConfig.CODEC);

    public TemplateFeature(Codec<TemplateFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<TemplateFeatureConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        TemplateFeatureConfig config = (TemplateFeatureConfig)context.config();
        return TemplateFeature.placeTemplate(level, pos, random, config.templateName());
    }

    public static boolean placeTemplate(WorldGenLevel level, BlockPos pos, RandomSource random, ResourceLocation templateName) {
        TemplateManager manager = TemplateManager.getInstance();
        if (!manager.isLoaded()) {
            return false;
        }
        List<StructureTemplate> templates = manager.getTemplates(templateName);
        if (templates.isEmpty()) {
            return false;
        }
        TemplateConfig templateConfig = manager.getConfig(templateName);
        if (templateConfig == null) {
            templateConfig = new TemplateConfig(templateName, "tree", List.of(), 0, false);
        }
        return TemplatePlacer.place(level, pos, random, templates, templateConfig);
    }
}

