/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation.template;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class TemplateManager {
    private static final TemplateManager INSTANCE = new TemplateManager();
    private final Map<ResourceLocation, List<StructureTemplate>> templateCache = new ConcurrentHashMap<ResourceLocation, List<StructureTemplate>>();
    private final Map<ResourceLocation, TemplateConfig> configCache = new ConcurrentHashMap<ResourceLocation, TemplateConfig>();
    private volatile boolean loaded = false;

    private TemplateManager() {
    }

    public static TemplateManager getInstance() {
        return INSTANCE;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load(ResourceManager resourceManager, StructureTemplateManager structureManager) {
        if (this.loaded) {
            return;
        }
        Terrano.LOG.info("Loading tree templates...");
        this.templateCache.clear();
        this.configCache.clear();
        Map configs = resourceManager.listResources("templates/trees", loc -> loc.getPath().endsWith(".json"));
        int loadedCount = 0;
        for (Map.Entry entry : configs.entrySet()) {
            ResourceLocation fullPath = (ResourceLocation)entry.getKey();
            String path = fullPath.getPath();
            String name = path.substring("templates/trees/".length(), path.length() - ".json".length());
            ResourceLocation templateId = ResourceLocation.fromNamespaceAndPath((String)fullPath.getNamespace(), (String)name);
            try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).open());){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                TemplateConfig config = TemplateConfig.parse(templateId, root);
                this.configCache.put(config.getName(), config);
                List<StructureTemplate> templates = this.loadStructures(config, resourceManager);
                if (!templates.isEmpty()) {
                    this.templateCache.put(config.getName(), templates);
                    ++loadedCount;
                    continue;
                }
                Terrano.LOG.warn("  Template '{}' has no structures!", (Object)config.getName());
            }
            catch (Exception e) {
                Terrano.LOG.error("  Failed to load template: {}", (Object)fullPath, (Object)e);
            }
        }
        this.loaded = true;
        Terrano.LOG.info("Loaded {} tree templates", (Object)loadedCount);
    }

    private List<StructureTemplate> loadStructures(TemplateConfig config, ResourceManager resourceManager) {
        ArrayList<StructureTemplate> templates = new ArrayList<StructureTemplate>();
        for (ResourceLocation structurePath : config.getStructurePaths()) {
            String namespace;
            String searchDir = "structures/" + structurePath.getPath();
            Map nbtFiles = resourceManager.listResources(searchDir, arg_0 -> TemplateManager.lambda$loadStructures$1(namespace = structurePath.getNamespace(), arg_0));
            if (nbtFiles.isEmpty()) {
                Terrano.LOG.warn("    No .nbt files found in: data/{}/{}", (Object)namespace, (Object)searchDir);
                continue;
            }
            for (Map.Entry nbtEntry : nbtFiles.entrySet()) {
                ResourceLocation nbtPath = (ResourceLocation)nbtEntry.getKey();
                try {
                    InputStream stream = ((Resource)nbtEntry.getValue()).open();
                    try {
                        CompoundTag nbt = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                        StructureTemplate template = new StructureTemplate();
                        template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbt);
                        templates.add(template);
                        Terrano.LOG.debug("    Loaded structure: {}", (Object)nbtPath);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Terrano.LOG.error("    Failed to load NBT: {}", (Object)nbtPath, (Object)e);
                }
            }
        }
        return templates;
    }

    public List<StructureTemplate> getTemplates(ResourceLocation name) {
        return this.templateCache.getOrDefault(name, Collections.emptyList());
    }

    public TemplateConfig getConfig(ResourceLocation name) {
        return this.configCache.get(name);
    }

    public boolean hasTemplate(ResourceLocation name) {
        return this.templateCache.containsKey(name) && !this.templateCache.get(name).isEmpty();
    }

    public void clear() {
        this.templateCache.clear();
        this.configCache.clear();
        this.loaded = false;
    }

    public Set<ResourceLocation> getTemplateNames() {
        return Collections.unmodifiableSet(this.templateCache.keySet());
    }

    private static /* synthetic */ boolean lambda$loadStructures$1(String namespace, ResourceLocation loc) {
        return loc.getNamespace().equals(namespace) && loc.getPath().endsWith(".nbt");
    }
}

