/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation.template;

import com.terrano.mod.worldgen.biome.vegetation.template.TemplateConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TemplatePlacer {
    public static boolean place(WorldGenLevel level, BlockPos pos, RandomSource random, List<StructureTemplate> templates, TemplateConfig config) {
        if (templates.isEmpty()) {
            return false;
        }
        StructureTemplate template = templates.get(random.nextInt(templates.size()));
        Rotation rotation = Rotation.getRandom((RandomSource)random);
        Mirror mirror = random.nextBoolean() ? Mirror.NONE : Mirror.LEFT_RIGHT;
        StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRandom(random).setIgnoreEntities(true).setKnownShape(true);
        Vec3i size = template.getSize(rotation);
        int sizeX = size.getX();
        int sizeZ = size.getZ();
        int offsetX = -(sizeX / 2);
        int offsetZ = -(sizeZ / 2);
        BlockPos placePos = pos.offset(offsetX, 0, offsetZ);
        if (!TemplatePlacer.canPlace(level, pos, size.getY(), config)) {
            return false;
        }
        settings.setRotationPivot(new BlockPos(sizeX / 2, 0, sizeZ / 2));
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)placePos, (Vec3i)placePos.offset(sizeX - 1, size.getY() - 1, sizeZ - 1));
        settings.setBoundingBox(bounds);
        boolean placed = template.placeInWorld((ServerLevelAccessor)level, placePos, placePos, settings, random, 2);
        if (placed && config.getExtendBase() > 0) {
            TemplatePlacer.extendBase(level, pos, config.getExtendBase());
        }
        return placed;
    }

    private static boolean canPlace(WorldGenLevel level, BlockPos pos, int height, TemplateConfig config) {
        BlockPos below = pos.below();
        BlockState ground = level.getBlockState(below);
        if (!TemplatePlacer.isSuitableGround(ground)) {
            return false;
        }
        BlockState atPos = level.getBlockState(pos);
        if (atPos.is(Blocks.WATER) || atPos.is(Blocks.LAVA)) {
            return false;
        }
        if (config.shouldCheckBounds()) {
            return TemplatePlacer.checkOverhead(level, pos, height);
        }
        return true;
    }

    private static boolean checkOverhead(WorldGenLevel level, BlockPos pos, int height) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int clearCount = 0;
        int checkHeight = Math.min(height, 8);
        for (int y = 0; y < checkHeight; ++y) {
            mutable.setY(pos.getY() + y);
            BlockState state = level.getBlockState((BlockPos)mutable);
            if (!TemplatePlacer.canTreeReplace(state)) continue;
            ++clearCount;
        }
        return (double)clearCount >= (double)checkHeight * 0.6;
    }

    private static void extendBase(WorldGenLevel level, BlockPos pos, int depth) {
        BlockState logState = level.getBlockState(pos);
        if (!logState.is(BlockTags.LOGS)) {
            for (int y = 1; y <= 3 && !(logState = level.getBlockState(pos.above(y))).is(BlockTags.LOGS); ++y) {
            }
        }
        if (!logState.is(BlockTags.LOGS)) {
            return;
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int y = 0; y < depth; ++y) {
            mutable.setY(pos.getY() - y - 1);
            BlockState existing = level.getBlockState((BlockPos)mutable);
            if (!TemplatePlacer.isSoil(existing) && !existing.isAir() && !TemplatePlacer.canTreeReplace(existing)) break;
            level.setBlock((BlockPos)mutable, logState, 2);
        }
    }

    private static boolean isSuitableGround(BlockState state) {
        return TemplatePlacer.isSoil(state);
    }

    private static boolean isSoil(BlockState state) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.FARMLAND) || state.is(Blocks.MUD) || state.is(Blocks.MUDDY_MANGROVE_ROOTS) || state.is(Blocks.MOSS_BLOCK) || state.is(Blocks.MYCELIUM) || state.is(Blocks.PODZOL);
    }

    private static boolean canTreeReplace(BlockState state) {
        return state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS) || state.is(Blocks.VINE) || state.is(Blocks.TALL_GRASS) || state.is(Blocks.SHORT_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN);
    }
}

