/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.biome.vegetation.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateManager;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TreeReplacer {
    private static final TreeReplacer INSTANCE = new TreeReplacer();
    private final List<ReplacementRule> rules = new ArrayList<ReplacementRule>();
    private final Map<ResourceLocation, List<ReplacementRule>> biomeRulesCache = new ConcurrentHashMap<ResourceLocation, List<ReplacementRule>>();
    private volatile boolean loaded = false;

    private TreeReplacer() {
    }

    public static TreeReplacer getInstance() {
        return INSTANCE;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load(ResourceManager resourceManager) {
        this.rules.clear();
        this.biomeRulesCache.clear();
        Terrano.LOG.info("Loading tree replacement rules...");
        Map configs = resourceManager.listResources("features/trees", loc -> loc.getPath().endsWith(".json"));
        int count = 0;
        for (Map.Entry entry : configs.entrySet()) {
            ResourceLocation path = (ResourceLocation)entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).open());){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                ReplacementRule rule = this.parseRule(root);
                if (rule == null) continue;
                this.rules.add(rule);
                ++count;
                Terrano.LOG.debug("  Loaded replacement rule from {} ({} biomes, {} templates)", (Object)path, (Object)rule.biomes.size(), (Object)rule.templates.size());
            }
            catch (Exception e) {
                Terrano.LOG.error("  Failed to load replacement rule: {}", (Object)path, (Object)e);
            }
        }
        this.loaded = true;
        Terrano.LOG.info("Loaded {} tree replacement rules", (Object)count);
    }

    private ReplacementRule parseRule(JsonObject root) {
        JsonElement matchElement;
        if (!root.has("biomes") || !root.has("replace")) {
            Terrano.LOG.warn("  Missing 'biomes' or 'replace' field");
            return null;
        }
        ArrayList<String> biomes = new ArrayList<String>();
        for (JsonElement biomeElement : root.getAsJsonArray("biomes")) {
            biomes.add(biomeElement.getAsString());
        }
        ArrayList<List<String>> matchBlocks = new ArrayList<List<String>>();
        if (root.has("match") && (matchElement = root.get("match")).isJsonArray()) {
            for (JsonElement matchGroup : matchElement.getAsJsonArray()) {
                ArrayList<String> group = new ArrayList<String>();
                if (matchGroup.isJsonArray()) {
                    for (JsonElement block : matchGroup.getAsJsonArray()) {
                        group.add(block.getAsString());
                    }
                } else if (matchGroup.isJsonPrimitive()) {
                    group.add(matchGroup.getAsString());
                }
                if (group.isEmpty()) continue;
                matchBlocks.add(group);
            }
        }
        List<TemplateEntry> templates = this.parseTemplates(root.getAsJsonObject("replace"));
        Terrano.LOG.debug("  Parsed rule: biomes={}, match={}, templates={}", (Object)biomes.size(), (Object)matchBlocks.size(), (Object)templates.size());
        if (templates.isEmpty()) {
            Terrano.LOG.warn("  No templates found. Replace JSON: {}", (Object)root.get("replace").toString().substring(0, Math.min(200, root.get("replace").toString().length())));
            return null;
        }
        return new ReplacementRule(biomes, matchBlocks, templates);
    }

    private List<TemplateEntry> parseTemplates(JsonObject replaceRoot) {
        ArrayList<TemplateEntry> entries = new ArrayList<TemplateEntry>();
        this.extractTemplates((JsonElement)replaceRoot, entries);
        return entries;
    }

    private void extractTemplates(JsonElement element, List<TemplateEntry> entries) {
        if (element == null || element.isJsonNull()) {
            return;
        }
        if (element.isJsonObject()) {
            JsonObject configObj;
            JsonElement configEl;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("template") && obj.get("template").isJsonPrimitive()) {
                String templateName = obj.get("template").getAsString();
                entries.add(new TemplateEntry(ResourceLocation.parse((String)templateName), 1.0f));
            }
            if (obj.has("config") && (configEl = obj.get("config")).isJsonObject() && (configObj = configEl.getAsJsonObject()).has("template") && configObj.get("template").isJsonPrimitive()) {
                String templateName = configObj.get("template").getAsString();
                boolean alreadyAdded = entries.stream().anyMatch(e -> e.templateName().toString().equals(templateName));
                if (!alreadyAdded) {
                    entries.add(new TemplateEntry(ResourceLocation.parse((String)templateName), 1.0f));
                }
            }
            if (obj.has("chance") && !entries.isEmpty()) {
                float chance = obj.get("chance").getAsFloat();
                int lastIdx = entries.size() - 1;
                TemplateEntry last = entries.get(lastIdx);
                entries.set(lastIdx, new TemplateEntry(last.templateName(), chance));
            }
            for (Map.Entry entry : obj.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("template") || key.equals("chance") || key.equals("biomes") || key.equals("match")) continue;
                this.extractTemplates((JsonElement)entry.getValue(), entries);
            }
        }
        if (element.isJsonArray()) {
            for (JsonElement item : element.getAsJsonArray()) {
                this.extractTemplates(item, entries);
            }
        }
    }

    public List<ReplacementRule> getRulesForBiome(ResourceLocation biomeName) {
        return this.biomeRulesCache.computeIfAbsent(biomeName, this::computeRulesForBiome);
    }

    private List<ReplacementRule> computeRulesForBiome(ResourceLocation biomeName) {
        ArrayList<ReplacementRule> result = new ArrayList<ReplacementRule>();
        String biomeStr = biomeName.toString();
        block0: for (ReplacementRule rule : this.rules) {
            for (String pattern : rule.biomes) {
                if (!this.matchesBiome(biomeStr, pattern)) continue;
                result.add(rule);
                continue block0;
            }
        }
        return result;
    }

    private boolean matchesBiome(String biomeName, String pattern) {
        if (pattern.endsWith("*")) {
            return biomeName.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return biomeName.equals(pattern);
    }

    public boolean shouldReplace(Holder<Biome> biome, PlacedFeature feature, Holder.Reference<PlacedFeature> featureHolder) {
        ResourceKey featureKey;
        ResourceKey biomeKey = biome.unwrapKey().orElse(null);
        if (biomeKey == null) {
            return false;
        }
        List<ReplacementRule> biomeRules = this.getRulesForBiome(biomeKey.location());
        if (biomeRules.isEmpty()) {
            return false;
        }
        ResourceKey resourceKey = featureKey = featureHolder != null ? featureHolder.key() : null;
        if (featureKey == null) {
            return false;
        }
        String featurePath = featureKey.location().getPath().toLowerCase();
        for (ReplacementRule rule : biomeRules) {
            for (List<String> matchGroup : rule.matchBlocks) {
                boolean allMatch = true;
                for (String block : matchGroup) {
                    String blockName = block.replace("minecraft:", "");
                    if (featurePath.contains(blockName) || this.containsBlock(featurePath, blockName)) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return true;
            }
        }
        return false;
    }

    public ResourceLocation selectTemplate(ResourceLocation biomeName, RandomSource random) {
        List<ReplacementRule> biomeRules = this.getRulesForBiome(biomeName);
        if (biomeRules.isEmpty()) {
            return null;
        }
        ReplacementRule rule = biomeRules.get(0);
        if (rule.templates.isEmpty()) {
            return null;
        }
        float roll = random.nextFloat();
        float cumulative = 0.0f;
        for (TemplateEntry entry : rule.templates) {
            if (!(roll <= (cumulative += entry.chance)) || !TemplateManager.getInstance().hasTemplate(entry.templateName)) continue;
            return entry.templateName;
        }
        for (TemplateEntry entry : rule.templates) {
            if (!TemplateManager.getInstance().hasTemplate(entry.templateName)) continue;
            return entry.templateName;
        }
        return null;
    }

    public List<TemplateEntry> getTemplatesForBiome(ResourceLocation biomeName) {
        List<ReplacementRule> biomeRules = this.getRulesForBiome(biomeName);
        ArrayList<TemplateEntry> result = new ArrayList<TemplateEntry>();
        for (ReplacementRule rule : biomeRules) {
            for (TemplateEntry entry : rule.templates) {
                if (!TemplateManager.getInstance().hasTemplate(entry.templateName)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    private boolean containsBlock(String featurePath, String blockName) {
        return featurePath.contains(blockName.replace("_log", "").replace("_leaves", ""));
    }

    public void clear() {
        this.rules.clear();
        this.biomeRulesCache.clear();
        this.loaded = false;
    }

    public record ReplacementRule(List<String> biomes, List<List<String>> matchBlocks, List<TemplateEntry> templates) {
    }

    public record TemplateEntry(ResourceLocation templateName, float chance) {
    }
}

