/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.cave;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.biome.util.BiomeList;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.noise.Module;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public class CarverChunk {
    private Holder<Biome> cached;
    private int cachedX;
    private int cachedZ;
    private int biomeListIndex = -1;
    private final BiomeList[] biomeLists;
    private final Map<NoiseCave, BiomeList> biomes = new IdentityHashMap<NoiseCave, BiomeList>();
    public Module mask;
    public Module modifier;
    public TerrainData terrainData;

    public CarverChunk(int size) {
        this.biomeLists = new BiomeList[size];
        for (int i = 0; i < this.biomeLists.length; ++i) {
            this.biomeLists[i] = new BiomeList();
        }
    }

    public CarverChunk reset() {
        this.cached = null;
        this.biomes.clear();
        this.biomeListIndex = -1;
        return this;
    }

    public BiomeList getBiomes(NoiseCave config) {
        return this.biomes.get(config);
    }

    public Holder<Biome> getBiome(int x, int z, NoiseCave config, Generator generator) {
        int biomeX = x >> 2;
        int biomeZ = z >> 2;
        if (this.cached == null || biomeX != this.cachedX || biomeZ != this.cachedZ) {
            this.cached = generator.getSource().getUnderGroundBiome(config.getSeed(), x, z, config.getType());
            this.cachedX = biomeX;
            this.cachedZ = biomeZ;
            this.biomes.computeIfAbsent(config, c -> this.nextList()).add(this.cached);
        }
        return this.cached;
    }

    public float getCarvingMask(int seed, int x, int z) {
        float noise = this.mask.getValue(x, z);
        float river = this.terrainData.getRiver().get(x, z);
        return 1.0f - noise * river;
    }

    private BiomeList nextList() {
        int i = this.biomeListIndex + 1;
        if (i < this.biomeLists.length) {
            this.biomeListIndex = i;
            return this.biomeLists[i].reset();
        }
        return new BiomeList();
    }
}

