/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.cave;

import com.terrano.mod.util.MathUtil;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.cave.CarverChunk;
import com.terrano.noise.util.NoiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.Heightmap;

public class NoiseCaveCarver {
    private static final int CHUNK_AREA = 256;

    public static void carve(int seed, ChunkAccess chunk, CarverChunk carver, Generator generator, NoiseCave config, boolean carve) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = generator.getMinY();
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        for (int i = 0; i < 256; ++i) {
            int bottom;
            int dx = i & 0xF;
            int dz = i >> 4;
            int x = startX + dx;
            int z = startZ + dz;
            int surface = NoiseCaveCarver.getSurface(seed, x, z, chunk, generator, carver);
            int y = config.getHeight(seed, x, z);
            float value = carver.modifier.getValue(x, z);
            int cavern = config.getCavernSize(seed, x, z, value);
            if (cavern == 0) continue;
            int floor = config.getFloorDepth(seed, x, z, cavern);
            int top = MathUtil.clamp(y + cavern, minY, surface);
            if (top - (bottom = MathUtil.clamp(y - floor, minY, surface)) < 2) continue;
            Holder<Biome> biome = carver.getBiome(x, z, config, generator);
            if (!carve) continue;
            NoiseCaveCarver.carve(chunk, biome, dx, dz, bottom, top, surface, pos);
        }
    }

    private static void carve(ChunkAccess chunk, Holder<Biome> biome, int dx, int dz, int bottom, int top, int surface, BlockPos.MutableBlockPos pos) {
        BlockState air = Blocks.AIR.defaultBlockState();
        int biomeX = dx >> 2;
        int biomeZ = dz >> 2;
        int maxBiomeY = surface - 16 >> 2;
        for (int cy = bottom; cy <= top; ++cy) {
            pos.set(dx, cy, dz);
            if (!chunk.getBlockState((BlockPos)pos).getFluidState().isEmpty()) continue;
            chunk.setBlockState((BlockPos)pos, air, false);
            if (cy >> 2 >= maxBiomeY) continue;
            int biomeY = (cy & 0xF) >> 2;
            int sectionIndex = chunk.getSectionIndex(cy);
            LevelChunkSection section = chunk.getSection(sectionIndex);
            PalettedContainer container = (PalettedContainer)section.getBiomes();
            container.set(biomeX, biomeY, biomeZ, biome);
        }
    }

    private static int getSurface(int seed, int x, int z, ChunkAccess chunk, Generator generator, CarverChunk carverChunk) {
        float mask = carverChunk.getCarvingMask(seed, x, z);
        int surface = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
        if (surface > generator.getSeaLevel() || surface < generator.getSeaLevel() - 16) {
            surface += 9;
        }
        return surface - NoiseUtil.floor(16.0f * mask);
    }
}

