/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.cave;

import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.Seeds;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.biome.util.BiomeList;
import com.terrano.mod.worldgen.cave.CarverChunk;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class NoiseCaveDecorator {
    public static void decorate(ChunkAccess chunk, CarverChunk carver, WorldGenLevel region, Generator generator, NoiseCave config) {
        BiomeList biomes = carver.getBiomes(config);
        if (biomes == null) {
            return;
        }
        int seed = Seeds.get(region);
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        int startY = config.getHeight(seed, startX, startZ);
        BlockPos pos = new BlockPos(startX, startY, startZ);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.getSeed()));
        for (int i = 0; i < biomes.size(); ++i) {
            Holder<Biome> biome = biomes.get(i);
            NoiseCaveDecorator.decorate(pos, region, generator, ((Biome)biome.value()).getGenerationSettings(), random);
        }
    }

    public static void decorate(BlockPos pos, WorldGenLevel region, Generator generator, BiomeGenerationSettings settings, WorldgenRandom random) {
        List features = settings.features();
        long baseSeed = random.setDecorationSeed(region.getSeed(), pos.getX(), pos.getZ());
        for (int stageIndex = 0; stageIndex < features.size(); ++stageIndex) {
            if (stageIndex < GenerationStep.Decoration.LOCAL_MODIFICATIONS.ordinal()) continue;
            HolderSet stage = (HolderSet)features.get(stageIndex);
            for (int featureIndex = 0; featureIndex < stage.size(); ++featureIndex) {
                random.setFeatureSeed(baseSeed, featureIndex, stageIndex);
                PlacedFeature feature = (PlacedFeature)stage.get(featureIndex).value();
                feature.placeWithBiomeCheck(region, (ChunkGenerator)generator, (RandomSource)random, pos);
            }
        }
    }
}

