/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.cave;

import com.terrano.mod.Terrano;
import com.terrano.mod.data.ModCaves;
import com.terrano.mod.util.storage.ObjectPool;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.cave.CarverChunk;
import com.terrano.mod.worldgen.cave.CaveType;
import com.terrano.mod.worldgen.cave.NoiseCaveCarver;
import com.terrano.mod.worldgen.cave.NoiseCaveDecorator;
import com.terrano.mod.worldgen.cave.UniqueCaveDistributor;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;

public class NoiseCaveGenerator {
    protected static final int POOL_SIZE = 32;
    protected static final float DENSITY = 0.05f;
    protected static final float BREACH_THRESHOLD = 0.7f;
    protected static final int GLOBAL_CAVE_REPS = 2;
    protected final NoiseCave[] caves;
    protected final Module uniqueCaveNoise;
    protected final Module caveBreachNoise;
    protected final ObjectPool<CarverChunk> pool;
    protected final Map<ChunkPos, CarverChunk> cache = new ConcurrentHashMap<ChunkPos, CarverChunk>();

    public NoiseCaveGenerator(RegistryAccess access) {
        NoiseCave[] loaded;
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise(500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise(300, 0.7f);
        try {
            Registry registry = access.registryOrThrow((ResourceKey)Terrano.CAVES.get());
            loaded = NoiseCaveGenerator.createArray((Iterable<NoiseCave>)registry);
            Terrano.LOG.info("[CAVES] Loaded {} cave configs from datapack", (Object)loaded.length);
        }
        catch (Exception e) {
            Terrano.LOG.warn("[CAVES] Failed to load cave registry: {}", (Object)e.getMessage());
            loaded = new NoiseCave[]{};
        }
        if (loaded.length == 0) {
            Terrano.LOG.info("[CAVES] Using fallback caves");
            loaded = ModCaves.Factory.getDefaults();
        }
        this.caves = loaded;
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
        Terrano.LOG.info("[CAVES] Final cave count: {}", (Object)this.caves.length);
    }

    public NoiseCaveGenerator(NoiseCaveGenerator other) {
        this.caves = other.caves;
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise(500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise(300, 0.7f);
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
    }

    public void carve(int seed, ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.getPreCarveChunk(chunk);
        carver.terrainData = generator.getChunkData(seed, chunk.getPos());
        carver.mask = this.caveBreachNoise;
        for (NoiseCave config : this.caves) {
            carver.modifier = this.getModifier(config);
            NoiseCaveCarver.carve(seed, chunk, carver, generator, config, true);
        }
    }

    public void decorate(int seed, ChunkAccess chunk, WorldGenLevel region, Generator generator) {
        CarverChunk carver = this.getPostCarveChunk(seed, chunk, generator);
        for (NoiseCave config : this.caves) {
            NoiseCaveDecorator.decorate(chunk, carver, region, generator, config);
        }
        this.pool.restore(carver);
    }

    private CarverChunk getPreCarveChunk(ChunkAccess chunk) {
        return this.cache.computeIfAbsent(chunk.getPos(), p -> this.pool.take().reset());
    }

    private CarverChunk getPostCarveChunk(int seed, ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.cache.remove(chunk.getPos());
        if (carver != null) {
            return carver;
        }
        carver = this.pool.take().reset();
        carver.mask = this.caveBreachNoise;
        carver.terrainData = generator.getChunkData(seed, chunk.getPos());
        for (NoiseCave config : this.caves) {
            carver.modifier = this.getModifier(config);
            NoiseCaveCarver.carve(seed, chunk, carver, generator, config, false);
        }
        return carver;
    }

    private Module getModifier(NoiseCave cave) {
        return switch (cave.getType()) {
            default -> throw new MatchException(null, null);
            case CaveType.GLOBAL -> Source.ONE;
            case CaveType.UNIQUE -> this.uniqueCaveNoise;
        };
    }

    private CarverChunk createCarverChunk() {
        return new CarverChunk(this.caves.length);
    }

    private static Module createUniqueNoise(int scale, float density) {
        return new UniqueCaveDistributor(1286745, 1.0f / (float)scale, 0.75f, density).clamp(0.2, 1.0).map(0.0, 1.0).warp(781624, 30, 1, 20.0);
    }

    private static Module createBreachNoise(int scale, float threshold) {
        return Source.simplexRidge(1567328, scale, 2).clamp(threshold * 0.8f, threshold).map(0.0, 1.0);
    }

    private static NoiseCave[] copyOf(long seed, NoiseCave[] other) {
        NoiseCave[] array = Arrays.copyOf(other, other.length);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].withSeed(seed);
        }
        return array;
    }

    private static NoiseCave[] createArray(Iterable<NoiseCave> source) {
        int length = 0;
        for (NoiseCave cave : source) {
            length += NoiseCaveGenerator.getCount(cave);
        }
        NoiseCave[] array = new NoiseCave[length];
        int i = 0;
        for (NoiseCave cave : source) {
            int count = NoiseCaveGenerator.getCount(cave);
            for (int j = 0; j < count; ++j) {
                array[i++] = cave.withSeed((long)j * 16421058L);
            }
        }
        return array;
    }

    private static int getCount(NoiseCave cave) {
        return cave.getType() == CaveType.GLOBAL ? 2 : 1;
    }
}

