/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.datapack;

import com.terrano.mod.CommonAPI;
import com.terrano.mod.Terrano;
import com.terrano.mod.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.tuple.Pair;

public class DataPackExporter {
    public static final String PACK_NAME = "Terrano-v1.0";
    public static final String PACK_FILE_NAME = "Terrano-v1.0.zip";
    public static final Path CONFIG_DIR = Paths.get("config", "terrano").toAbsolutePath();
    public static final Path DEFAULT_PACK_DIR = CONFIG_DIR.resolve("pack-v1.0");

    public static void extractDefaultPack() {
        try {
            Path defaultPath;
            Terrano.LOG.info("Extracting default datapack to {}", (Object)DEFAULT_PACK_DIR);
            Path root = CommonAPI.get().getContainer();
            if (!Files.exists(root, new LinkOption[0])) {
                Terrano.LOG.warn("Container path does not exist: {}, skipping datapack extraction", (Object)root);
                return;
            }
            if (Files.isDirectory(root, new LinkOption[0]) && !Files.exists(defaultPath = root.resolve("default"), new LinkOption[0])) {
                Terrano.LOG.warn("Default datapack source not found at: {}, skipping extraction", (Object)defaultPath);
                return;
            }
            Files.createDirectories(DEFAULT_PACK_DIR, new FileAttribute[0]);
            FileUtil.createDirCopy(root, "default", DEFAULT_PACK_DIR);
            Terrano.LOG.info("Successfully extracted default datapack");
        }
        catch (IOException e) {
            Terrano.LOG.warn("Failed to extract default datapack: {}", (Object)e.getMessage());
        }
    }

    public static Pair<Path, String> getDefaultsPath() {
        if (!Files.exists(DEFAULT_PACK_DIR, new LinkOption[0])) {
            DataPackExporter.extractDefaultPack();
            if (!Files.exists(DEFAULT_PACK_DIR, new LinkOption[0])) {
                Terrano.LOG.warn("Default datapack not available at {}", (Object)DEFAULT_PACK_DIR);
                return null;
            }
        }
        return Pair.of((Object)DEFAULT_PACK_DIR, (Object)".");
    }

    public static void createWorldDatapack(Path dir) {
        Pair<Path, String> src = DataPackExporter.getDefaultsPath();
        if (src == null) {
            Terrano.LOG.info("Skipping world datapack creation - no source available");
            return;
        }
        Terrano.LOG.info("Copying world-instance datapack to {}", (Object)dir);
        try {
            Path dest = dir.resolve(PACK_FILE_NAME);
            FileUtil.createZipCopy((Path)src.getLeft(), (String)src.getRight(), dest);
        }
        catch (IOException e) {
            Terrano.LOG.error("Failed to create world datapack", (Throwable)e);
        }
    }
}

