/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.noise;

import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import com.terrano.noise.util.NoiseUtil;

public class NoiseLevels {
    public final boolean auto;
    public final float scale;
    public final float unit;
    public final float depthMin;
    public final float depthRange;
    public final float heightMin;
    public final float baseRange;
    public final float heightRange;
    public final float frequency;

    public NoiseLevels(boolean autoScale, float scale, int seaLevel, int seaFloor, int worldHeight, int baseHeight) {
        this.auto = autoScale;
        this.scale = scale;
        this.unit = 1.0f / (float)worldHeight;
        this.depthMin = (float)seaFloor / (float)worldHeight;
        this.heightMin = (float)seaLevel / (float)worldHeight;
        this.baseRange = (float)Math.max(0, baseHeight - seaLevel) / (float)worldHeight;
        this.heightRange = 1.0f - this.heightMin - this.baseRange;
        this.depthRange = this.heightMin - this.depthMin;
        this.frequency = NoiseLevels.calcFrequency(worldHeight - seaLevel, this.auto, scale);
        Terrano.LOG.debug("Sea Level: {}, Base Height:  {}, World Height: {}", (Object)seaLevel, (Object)baseHeight, (Object)worldHeight);
        System.out.println("[Terrano] NoiseLevels created:");
        System.out.println("  - seaLevel: " + seaLevel + " / worldHeight: " + worldHeight);
        System.out.println("  - heightMin (sea level): " + this.heightMin);
        System.out.println("  - baseRange (land base above sea): " + this.baseRange);
        System.out.println("  - heightRange (terrain variation): " + this.heightRange);
        System.out.println("  - depthMin: " + this.depthMin);
        System.out.println("  - depthRange: " + this.depthRange);
        float testPlains = this.toHeightNoise(0.5f, 0.055000003f);
        float testHills = this.toHeightNoise(0.5f, 0.22000001f);
        float testMountains = this.toHeightNoise(0.5f, 0.44000003f);
        System.out.println("  - TEST plains height: " + testPlains * (float)worldHeight + " blocks");
        System.out.println("  - TEST hills height: " + testHills * (float)worldHeight + " blocks");
        System.out.println("  - TEST mountains height: " + testMountains * (float)worldHeight + " blocks");
    }

    public float scale(int level) {
        return (float)level * this.unit;
    }

    public float toDepthNoise(float noise) {
        return this.depthMin + noise * this.depthRange;
    }

    public float toHeightNoise(float baseNoise, float heightNoise) {
        return this.heightMin + this.baseRange * baseNoise + this.heightRange * heightNoise;
    }

    public float floor(float value) {
        return (float)NoiseUtil.floor(value / this.unit) * this.unit;
    }

    public float ceil(float value) {
        return this.unit + (float)NoiseUtil.floor(value / this.unit) * this.unit;
    }

    public static NoiseLevels getDefault() {
        return TerrainLevels.DEFAULT.get().noiseLevels;
    }

    public static float calcFrequency(int verticalRange, boolean auto, float scale) {
        float f = scale = scale <= 0.0f ? 1.0f : scale;
        if (!auto) {
            return scale;
        }
        float frequency = 193.0f / (float)verticalRange;
        return frequency * scale;
    }
}

