/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.noise.erosion;

import com.terrano.engine.util.FastRandom;
import com.terrano.mod.util.storage.ObjectMap;
import com.terrano.mod.worldgen.noise.NoiseData;
import com.terrano.mod.worldgen.noise.NoiseSample;
import com.terrano.mod.worldgen.noise.erosion.ErosionFilter;
import com.terrano.mod.worldgen.noise.erosion.NoiseTileSize;
import java.util.concurrent.CompletableFuture;

public class NoiseResource {
    public final FastRandom random = new FastRandom();
    public final NoiseData chunk = new NoiseData();
    public final ErosionFilter.Resource erosionResource = new ErosionFilter.Resource();
    public final float[] heightmap;
    public final NoiseSample sharedSample;
    public final ObjectMap<NoiseSample> chunkSample;
    public final CompletableFuture<float[]>[] chunkCache;

    public NoiseResource() {
        this(NoiseTileSize.DEFAULT);
    }

    public NoiseResource(NoiseTileSize tileSize) {
        this.heightmap = new float[tileSize.regionSize];
        this.sharedSample = new NoiseSample();
        this.chunkSample = new ObjectMap(1, NoiseSample[]::new);
        this.chunkSample.fill(NoiseSample::new);
        this.chunkCache = new CompletableFuture[tileSize.chunkSize];
    }

    public NoiseSample getSample(int dx, int dz) {
        return NoiseData.isInsideChunk(dx, dz) ? this.chunkSample.get(dx, dz) : this.sharedSample;
    }
}

