/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.terrain;

import com.terrano.engine.util.pos.PosUtil;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.util.MathUtil;
import com.terrano.mod.util.SpiralIterator;
import com.terrano.mod.util.seed.Seedable;
import com.terrano.mod.util.storage.Object2FloatCache;
import com.terrano.mod.util.storage.WeightMap;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import com.terrano.noise.domain.Domain;
import com.terrano.noise.util.NoiseUtil;
import java.util.Arrays;
import net.minecraft.core.Holder;

public class TerrainBlender
implements Seedable<TerrainBlender> {
    private static final int REGION_SEED_OFFSET = 21491124;
    private static final int WARP_SEED_OFFSET = 12678;
    private final int seed;
    private final int scale;
    private final float frequency;
    private final float jitter;
    private final float blending;
    private final Domain warp;
    private final WeightMap<TerrainNoise> terrains;
    private final ThreadLocal<Blender> localBlender = ThreadLocal.withInitial(Blender::new);

    public TerrainBlender(long seed, int scale, float jitter, float blending, TerrainNoise[] terrains) {
        this.seed = (int)seed;
        this.scale = scale;
        this.frequency = 1.0f / (float)scale;
        this.jitter = jitter;
        this.blending = blending;
        WeightMap.Weighted[] filtered = TerrainBlender.filterTerrains(terrains);
        this.terrains = WeightMap.of((WeightMap.Weighted[])filtered);
        this.warp = Domain.warp(Source.SIMPLEX, (int)seed + 12678, scale, 3, (float)scale / 2.5f);
    }

    private static TerrainNoise[] filterTerrains(TerrainNoise[] terrains) {
        if (terrains == null || terrains.length == 0) {
            System.err.println("[Terrano] Warning: No terrains provided to TerrainBlender, using fallback");
            return TerrainBlender.createFallbackTerrains();
        }
        TerrainNoise[] filtered = (TerrainNoise[])Arrays.stream(terrains).filter(t -> t != null).filter(t -> {
            try {
                return t.noise() != null && t.terrain() != null;
            }
            catch (Exception e) {
                System.err.println("[Terrano] Warning: Invalid TerrainNoise entry: " + e.getMessage());
                return false;
            }
        }).toArray(TerrainNoise[]::new);
        if (filtered.length == 0) {
            System.err.println("[Terrano] Warning: All terrains were null/invalid, using fallback. Original count: " + terrains.length);
            return TerrainBlender.createFallbackTerrains();
        }
        System.out.println("[Terrano] TerrainBlender: Loaded " + filtered.length + " terrain types (from " + terrains.length + ")");
        for (TerrainNoise t2 : filtered) {
            System.out.println("[Terrano]   - " + t2.terrain().getName() + " (weight: " + t2.weight() + ")");
        }
        return filtered;
    }

    private static TerrainNoise[] createFallbackTerrains() {
        System.out.println("[Terrano] Creating fallback terrain types...");
        return new TerrainNoise[]{TerrainBlender.createFallbackTerrain("plains", com.terrano.engine.world.terrain.TerrainType.FLATS, 3.0f, 0.25f, 150), TerrainBlender.createFallbackTerrain("hills", com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, 0.45f, 100), TerrainBlender.createFallbackTerrain("mountains", com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.0f, 0.7f, 80)};
    }

    private static TerrainNoise createFallbackTerrain(String name, Terrain parentTerrain, float weight, float baseHeight, int noiseScale) {
        Module noise = Source.simplex(name.hashCode(), noiseScale, 4).scale(0.4).bias(baseHeight).clamp(0.0, 1.0);
        TerrainType terrainTypeAsset = new TerrainType(name, parentTerrain);
        return new TerrainNoise((Holder<TerrainType>)Holder.direct((Object)terrainTypeAsset), weight, noise);
    }

    @Override
    public TerrainBlender withSeed(long seed) {
        TerrainNoise[] input = this.terrains.getValues();
        TerrainNoise[] output = new TerrainNoise[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = input[i].withSeed(seed);
        }
        return new TerrainBlender(seed, this.scale, this.jitter, this.blending, output);
    }

    public int getSeed() {
        return this.seed;
    }

    public float getValue(int externalSeed, float x, float z) {
        Blender blender = this.localBlender.get();
        return this.getValue(externalSeed, x, z, blender);
    }

    public float getValue(int externalSeed, float x, float z, Blender blender) {
        int combinedSeed = this.seed ^ externalSeed;
        float rx = this.warp.getX(x, z) * this.frequency;
        float rz = this.warp.getY(x, z) * this.frequency;
        TerrainBlender.getCell(combinedSeed + 21491124, rx, rz, this.jitter, blender);
        return blender.getValue(combinedSeed, x, z, this.blending, this.terrains);
    }

    public Blender getBlenderResource() {
        return this.localBlender.get();
    }

    public Terrain getTerrain(Blender blender) {
        float index = blender.getCentreNoiseIndex();
        TerrainNoise terrainNoise = this.terrains.getValue(index);
        if (terrainNoise == null) {
            return com.terrano.engine.world.terrain.TerrainType.NONE;
        }
        try {
            Terrain terrain = terrainNoise.terrain();
            return terrain != null ? terrain : com.terrano.engine.world.terrain.TerrainType.NONE;
        }
        catch (Exception e) {
            return com.terrano.engine.world.terrain.TerrainType.NONE;
        }
    }

    public SpiralIterator.PositionFinder findNearest(int externalSeed, float x, float z, int minRadius, int maxRadius, Terrain type) {
        TerrainNoise terrain = this.terrains.find(t -> {
            if (t == null) {
                return false;
            }
            try {
                Terrain tr = t.terrain();
                return tr != null && tr.getName().equals(type.getName());
            }
            catch (Exception e) {
                return false;
            }
        });
        if (terrain == null) {
            return null;
        }
        long band = this.terrains.getBand(terrain);
        float lower = PosUtil.unpackLeftf(band);
        float upper = PosUtil.unpackRightf(band);
        int combinedSeed = this.seed ^ externalSeed;
        return this.iterator(x, z, minRadius, maxRadius).finder(it -> {
            long pos = TerrainBlender.find(combinedSeed + 21491124, this.jitter, lower, upper, it);
            float px = PosUtil.unpackLeftf(pos) / this.frequency;
            float pz = PosUtil.unpackRightf(pos) / this.frequency;
            return PosUtil.packf(px, pz);
        });
    }

    public SpiralIterator iterator(float x, float z, int min, int max) {
        float rx = this.warp.getX(x, z) * this.frequency;
        float rz = this.warp.getY(x, z) * this.frequency;
        int cx = NoiseUtil.floor(rx);
        int cz = NoiseUtil.floor(rz);
        return new SpiralIterator(cx, cz, min, max);
    }

    private static long find(int seed, float jitter, float lower, float upper, SpiralIterator iterator) {
        while (iterator.hasNext()) {
            int cz;
            long next = iterator.next();
            int cx = PosUtil.unpackLeft(next);
            int hash = NoiseUtil.hash2D(seed, cx, cz = PosUtil.unpackRight(next));
            float noise = MathUtil.rand(hash);
            if (!(noise > lower) || !(noise <= upper)) continue;
            float dx = MathUtil.rand(hash, 1619);
            float dz = MathUtil.rand(hash, 31337);
            float px = (float)cx + dx * jitter;
            float pz = (float)cz + dz * jitter;
            return PosUtil.packf(px, pz);
        }
        return 0L;
    }

    private static void getCell(int seed, float x, float z, float jitter, Blender blender) {
        int maxX = NoiseUtil.floor(x) + 1;
        int maxZ = NoiseUtil.floor(z) + 1;
        blender.closestIndex = 0;
        blender.closestIndex2 = 0;
        int nearestIndex = -1;
        int nearestIndex2 = -1;
        float nearestDistance = Float.MAX_VALUE;
        float nearestDistance2 = Float.MAX_VALUE;
        int i = 0;
        for (int cz = maxZ - 2; cz <= maxZ; ++cz) {
            int cx = maxX - 2;
            while (cx <= maxX) {
                int hash = NoiseUtil.hash2D(seed, cx, cz);
                float dx = MathUtil.rand(hash, 1619);
                float dz = MathUtil.rand(hash, 31337);
                float px = (float)cx + dx * jitter;
                float pz = (float)cz + dz * jitter;
                float dist2 = NoiseUtil.dist2(x, z, px, pz);
                blender.hashes[i] = hash;
                blender.distances[i] = dist2;
                if (dist2 < nearestDistance) {
                    nearestDistance2 = nearestDistance;
                    nearestDistance = dist2;
                    nearestIndex2 = nearestIndex;
                    nearestIndex = i;
                } else if (dist2 < nearestDistance2) {
                    nearestDistance2 = dist2;
                    nearestIndex2 = i;
                }
                ++cx;
                ++i;
            }
        }
        blender.closestIndex = nearestIndex;
        blender.closestIndex2 = nearestIndex2;
    }

    public static class Blender {
        protected int closestIndex;
        protected int closestIndex2;
        protected final int[] hashes = new int[9];
        protected final float[] distances = new float[9];
        protected final Object2FloatCache<TerrainNoise> cache = new Object2FloatCache(9);

        public float getCentreNoiseIndex() {
            return this.getNoiseIndex(this.closestIndex);
        }

        public float getDistance(int index) {
            return NoiseUtil.sqrt(this.distances[index]);
        }

        public float getCentreValue(int seed, float x, float z, WeightMap<TerrainNoise> terrains) {
            float noise = this.getCentreNoiseIndex();
            TerrainNoise terrainNoise = terrains.getValue(noise);
            if (terrainNoise == null) {
                return 0.5f;
            }
            try {
                Module noiseModule = terrainNoise.noise();
                return noiseModule != null ? noiseModule.getValue(x, z) : 0.5f;
            }
            catch (Exception e) {
                return 0.5f;
            }
        }

        public float getValue(int seed, float x, float z, float blending, WeightMap<TerrainNoise> terrains) {
            float blendRadius;
            float dist1;
            float borderDistance;
            float blendStart;
            float dist0 = this.getDistance(this.closestIndex);
            if (dist0 <= (blendStart = (borderDistance = (dist0 + (dist1 = this.getDistance(this.closestIndex2))) * 0.5f) - (blendRadius = borderDistance * blending))) {
                return this.getCentreValue(seed, x, z, terrains);
            }
            return this.getBlendedValue(seed, x, z, dist0, dist1, blendRadius, terrains);
        }

        public float getBlendedValue(int seed, float x, float z, float nearest, float nearest2, float blendRange, WeightMap<TerrainNoise> terrains) {
            this.cache.clear();
            float sumNoise = this.getCacheValue(seed, this.closestIndex, x, z, terrains);
            float sumWeight = Blender.getWeight(nearest, nearest, blendRange);
            float nearestWeight2 = Blender.getWeight(nearest2, nearest, blendRange);
            if (nearestWeight2 > 0.0f) {
                sumNoise += this.getCacheValue(seed, this.closestIndex2, x, z, terrains) * nearestWeight2;
                sumWeight += nearestWeight2;
            }
            for (int i = 0; i < 9; ++i) {
                float weight;
                if (i == this.closestIndex || i == this.closestIndex2 || !((weight = Blender.getWeight(this.getDistance(i), nearest, blendRange)) > 0.0f)) continue;
                sumNoise += this.getCacheValue(seed, i, x, z, terrains) * weight;
                sumWeight += weight;
            }
            if (sumWeight <= 0.0f) {
                return 0.5f;
            }
            return NoiseUtil.clamp(sumNoise / sumWeight, 0.0f, 1.0f);
        }

        private float getCacheValue(int seed, int index, float x, float z, WeightMap<TerrainNoise> terrains) {
            float noiseIndex = this.getNoiseIndex(index);
            TerrainNoise terrain = terrains.getValue(noiseIndex);
            if (terrain == null) {
                return 0.5f;
            }
            float value = this.cache.get(terrain);
            if (Float.isNaN(value)) {
                try {
                    Module noiseModule = terrain.noise();
                    value = noiseModule != null ? noiseModule.getValue(x, z) : 0.5f;
                }
                catch (Exception e) {
                    value = 0.5f;
                }
                this.cache.put(terrain, value);
            }
            return value;
        }

        private float getNoiseIndex(int index) {
            return MathUtil.rand(this.hashes[index]);
        }

        private static float getWeight(float dist, float origin, float blendRange) {
            float delta = dist - origin;
            if (delta <= 0.0f) {
                return 1.0f;
            }
            if (delta >= blendRange) {
                return 0.0f;
            }
            float weight = 1.0f - delta / blendRange;
            return weight * weight;
        }
    }
}

