/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.terrain;

import com.terrano.mod.util.storage.ObjectPool;
import com.terrano.mod.worldgen.noise.INoiseGenerator;
import com.terrano.mod.worldgen.noise.NoiseSample;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.terrain.TerrainGenerator;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import com.terrano.mod.worldgen.util.ThreadPool;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public class TerrainCache {
    private final TerrainGenerator generator;
    private final Map<CacheKey, CacheValue> cache = new ConcurrentHashMap<CacheKey, CacheValue>(512);
    private final ThreadLocal<CacheKey> localKey = ThreadLocal.withInitial(CacheKey::new);
    private final ObjectPool<CacheKey> keyPool = new ObjectPool<CacheKey>(512, CacheKey::new);
    private final ObjectPool<CacheValue> valuePool = new ObjectPool<CacheValue>(512, CacheValue::new);

    public TerrainCache(TerrainLevels levels, INoiseGenerator noiseGenerator) {
        this.generator = new TerrainGenerator(levels, noiseGenerator);
    }

    protected CacheKey allocPos(int seed, ChunkPos pos) {
        return this.keyPool.take().set(seed, pos.x, pos.z);
    }

    protected CacheKey lookupPos(int seed, ChunkPos pos) {
        return this.localKey.get().set(seed, pos.x, pos.z);
    }

    public void drop(int seed, ChunkPos pos) {
        CacheKey key = this.lookupPos(seed, pos);
        CacheValue value = this.cache.remove(key);
        if (value == null || value.task == null) {
            return;
        }
        this.generator.restore(value.task.join());
        this.keyPool.restore(value.key);
        this.valuePool.restore(value.reset());
    }

    public void hint(int seed, ChunkPos pos) {
        this.getAsync(seed, pos);
    }

    public int getHeight(int seed, int x, int z) {
        return this.generator.getHeight(seed, x, z);
    }

    public NoiseSample getSample(int seed, int x, int z) {
        return this.generator.noiseGenerator.getNoiseSample(seed, x, z);
    }

    public void sample(int seed, int x, int z, NoiseSample sample) {
        this.generator.getNoiseGenerator().sample(seed, x, z, sample);
    }

    public TerrainData getNow(int seed, ChunkPos pos) {
        return this.getAsync(seed, pos).join();
    }

    @Nullable
    public TerrainData getIfReady(int seed, ChunkPos pos) {
        CacheKey key = this.allocPos(seed, pos);
        CacheValue value = this.cache.get(key);
        if (value == null || !value.task.isDone()) {
            return null;
        }
        return value.task.join();
    }

    public CompletableFuture<TerrainData> getAsync(int seed, ChunkPos pos) {
        CacheKey key = this.allocPos(seed, pos);
        return this.cache.computeIfAbsent((CacheKey)key, (Function<CacheKey, CacheValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, generate(com.terrano.mod.worldgen.terrain.TerrainCache$CacheKey ), (Lcom/terrano/mod/worldgen/terrain/TerrainCache$CacheKey;)Lcom/terrano/mod/worldgen/terrain/TerrainCache$CacheValue;)((TerrainCache)this)).task;
    }

    public <T> CompletableFuture<ChunkAccess> combineAsync(Executor executor, int seed, ChunkAccess chunk, BiFunction<ChunkAccess, TerrainData, ChunkAccess> function) {
        return this.getAsync(seed, chunk.getPos()).thenApplyAsync(terrainData -> (ChunkAccess)function.apply(chunk, (TerrainData)terrainData), executor);
    }

    protected CacheValue generate(CacheKey key) {
        CacheValue value = this.valuePool.take();
        value.key = key;
        value.generator = this.generator;
        value.task = CompletableFuture.supplyAsync(value, ThreadPool.EXECUTOR);
        return value;
    }

    protected static class CacheKey {
        protected int seed;
        protected int x;
        protected int z;

        protected CacheKey() {
        }

        public CacheKey set(int seed, int x, int y) {
            this.seed = seed;
            this.x = x;
            this.z = y;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) return false;
            CacheKey pos = (CacheKey)obj;
            if (this.seed != pos.seed) return false;
            if (this.x != pos.x) return false;
            if (this.z != pos.z) return false;
            return true;
        }

        public int hashCode() {
            int result = this.seed;
            result = 31 * result + this.x;
            result = 31 * result + this.z;
            return result;
        }
    }

    protected static class CacheValue
    implements Supplier<TerrainData> {
        protected CacheKey key;
        protected TerrainGenerator generator;
        protected CompletableFuture<TerrainData> task;

        protected CacheValue() {
        }

        public CacheValue reset() {
            this.key = null;
            this.task = null;
            this.generator = null;
            return this;
        }

        @Override
        public TerrainData get() {
            return this.generator.generate(this.key.seed, this.key.x, this.key.z);
        }
    }
}

