/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.terrain;

import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.util.storage.FloatMap;
import com.terrano.mod.util.storage.ObjectMap;
import com.terrano.mod.worldgen.noise.NoiseData;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import com.terrano.noise.util.NoiseUtil;
import java.util.function.Consumer;

public class TerrainData
implements Consumer<NoiseData> {
    protected static final int BORDER = 1;
    protected final TerrainLevels levels;
    protected final FloatMap height = new FloatMap(1);
    protected final FloatMap baseHeight = new FloatMap(1);
    protected final ObjectMap<Terrain> terrain = new ObjectMap(1, Terrain[]::new);
    protected final FloatMap gradient = new FloatMap();
    protected final FloatMap river = new FloatMap();
    protected float min = Float.MAX_VALUE;
    protected float max = Float.MIN_VALUE;
    protected float maxBase = Float.MIN_VALUE;

    public TerrainData(TerrainLevels levels) {
        this.levels = levels;
    }

    public int getMin() {
        return this.levels.getHeight(this.min);
    }

    public int getMax() {
        return this.levels.getHeight(this.max);
    }

    public int getMaxBase() {
        return this.levels.getHeight(this.maxBase);
    }

    public int getHeight(int x, int z) {
        float scaledHeight = this.height.get(x, z);
        return this.levels.getHeight(scaledHeight);
    }

    public int getBaseHeight(int x, int z) {
        float scaledLevel = this.baseHeight.get(x, z);
        return this.levels.getHeight(scaledLevel);
    }

    public int getHeightSafe(int worldX, int worldZ, int chunkMinX, int chunkMinZ) {
        int localX = TerrainData.clampLocal(worldX - chunkMinX);
        int localZ = TerrainData.clampLocal(worldZ - chunkMinZ);
        return this.getHeight(localX, localZ);
    }

    public int getBaseHeightSafe(int worldX, int worldZ, int chunkMinX, int chunkMinZ) {
        int localX = TerrainData.clampLocal(worldX - chunkMinX);
        int localZ = TerrainData.clampLocal(worldZ - chunkMinZ);
        return this.getBaseHeight(localX, localZ);
    }

    private static int clampLocal(int v) {
        return Math.max(-1, Math.min(16, v));
    }

    public TerrainLevels getLevels() {
        return this.levels;
    }

    public FloatMap getHeight() {
        return this.height;
    }

    public FloatMap getBaseHeight() {
        return this.baseHeight;
    }

    public FloatMap getGradient() {
        return this.gradient;
    }

    public FloatMap getRiver() {
        return this.river;
    }

    public ObjectMap<Terrain> getTerrain() {
        return this.terrain;
    }

    public float getGradient(int x, int z, float norm) {
        float grad = this.getGradient().get(x, z);
        return NoiseUtil.clamp(grad * norm, 0.0f, 1.0f);
    }

    @Override
    public void accept(NoiseData noiseData) {
        int x;
        int z;
        FloatMap basemap = noiseData.getBase();
        FloatMap heightmap = noiseData.getHeight();
        ObjectMap<Terrain> terrainMap = noiseData.getTerrain();
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        this.maxBase = Float.MIN_VALUE;
        for (z = -1; z < 17; ++z) {
            for (x = -1; x < 17; ++x) {
                float heightNoise = heightmap.get(x, z);
                float baseLevelNoise = basemap.get(x, z);
                float scaledHeight = this.levels.getScaledHeight(heightNoise);
                float scaledBaseLevel = this.levels.getScaledBaseLevel(baseLevelNoise);
                this.height.set(x, z, scaledHeight);
                this.baseHeight.set(x, z, scaledBaseLevel);
                this.terrain.set(x, z, terrainMap.get(x, z));
            }
        }
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                float n = heightmap.get(x, z - 1);
                float s = heightmap.get(x, z + 1);
                float e = heightmap.get(x + 1, z);
                float w = heightmap.get(x - 1, z);
                float dx = e - w;
                float dz = s - n;
                float grad = NoiseUtil.sqrt(dx * dx + dz * dz);
                float noiseGrad = NoiseUtil.clamp(grad, 0.0f, 1.0f);
                this.gradient.set(x, z, noiseGrad);
                this.river.set(x, z, noiseData.getRiver().get(x, z));
                float scaledHeight = this.height.get(x, z);
                float scaledBaseLevel = this.baseHeight.get(x, z);
                this.max = Math.max(this.max, scaledHeight);
                this.min = Math.min(this.min, scaledHeight);
                this.maxBase = Math.max(this.maxBase, scaledBaseLevel);
            }
        }
    }

    public void blendEdges(TerrainData north, TerrainData south, TerrainData east, TerrainData west) {
        int z;
        float neighbor;
        float current;
        int x;
        if (north == null && south == null && east == null && west == null) {
            return;
        }
        if (north != null) {
            for (x = 0; x < 16; ++x) {
                current = this.height.get(x, 0);
                neighbor = north.height.get(x, 15);
                this.height.set(x, 0, current * 0.7f + neighbor * 0.3f);
            }
        }
        if (south != null) {
            for (x = 0; x < 16; ++x) {
                current = this.height.get(x, 15);
                neighbor = south.height.get(x, 0);
                this.height.set(x, 15, current * 0.7f + neighbor * 0.3f);
            }
        }
        if (east != null) {
            for (z = 0; z < 16; ++z) {
                current = this.height.get(15, z);
                neighbor = east.height.get(0, z);
                this.height.set(15, z, current * 0.7f + neighbor * 0.3f);
            }
        }
        if (west != null) {
            for (z = 0; z < 16; ++z) {
                current = this.height.get(0, z);
                neighbor = west.height.get(15, z);
                this.height.set(0, z, current * 0.7f + neighbor * 0.3f);
            }
        }
        this.recalculateBounds();
    }

    private void recalculateBounds() {
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        this.maxBase = Float.MIN_VALUE;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float h = this.height.get(x, z);
                float b = this.baseHeight.get(x, z);
                this.min = Math.min(this.min, h);
                this.max = Math.max(this.max, h);
                this.maxBase = Math.max(this.maxBase, b);
            }
        }
    }
}

