/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.util;

import com.google.common.base.Suppliers;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.worldgen.GeneratorResource;
import com.terrano.mod.worldgen.biome.Source;
import com.terrano.mod.worldgen.terrain.StructureTerrain;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.terrain.TerrainLevels;
import com.terrano.mod.worldgen.util.BiomeBuffer2D;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.IdMapper;
import net.minecraft.core.QuartPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkUtil {
    private static final BlockState STONE = Blocks.STONE.defaultBlockState();
    private static final BlockState DIRT = Blocks.DIRT.defaultBlockState();
    private static final BlockState GRASS_BLOCK = Blocks.GRASS_BLOCK.defaultBlockState();
    private static final BlockState WATER = Blocks.WATER.defaultBlockState();
    private static final BlockState GRAVEL = Blocks.GRAVEL.defaultBlockState();
    private static final BlockState SAND = Blocks.SAND.defaultBlockState();
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private static final BlockState ANDESITE = Blocks.ANDESITE.defaultBlockState();
    private static final BlockState DIORITE = Blocks.DIORITE.defaultBlockState();
    private static final BlockState GRANITE = Blocks.GRANITE.defaultBlockState();
    private static final BlockState COBBLESTONE = Blocks.COBBLESTONE.defaultBlockState();
    private static final BlockState SNOW_BLOCK = Blocks.SNOW_BLOCK.defaultBlockState();
    private static final BlockState PACKED_ICE = Blocks.PACKED_ICE.defaultBlockState();
    private static final BlockState SANDSTONE = Blocks.SANDSTONE.defaultBlockState();
    private static final BlockState COARSE_DIRT = Blocks.COARSE_DIRT.defaultBlockState();
    private static final int DIRT_DEPTH = 4;
    public static final FillerBlock FILLER = ChunkUtil::getSimpleFiller;
    public static final Supplier<ByteBuf> FULL_SECTION = Suppliers.memoize(ChunkUtil::createFullPalette);

    public static void fillNoiseBiomes(ChunkAccess chunk, BiomeSource source, GeneratorResource resource) {
        ChunkPos pos = chunk.getPos();
        int biomeX = QuartPos.fromBlock((int)pos.getMinBlockX());
        int biomeZ = QuartPos.fromBlock((int)pos.getMinBlockZ());
        LevelHeightAccessor heightAccessor = chunk.getHeightAccessorForGeneration();
        BiomeBuffer2D biomeBuffer = resource.biomeBuffer2D;
        for (int dz = 0; dz < 4; ++dz) {
            for (int dx = 0; dx < 4; ++dx) {
                Holder biome = source.getNoiseBiome(biomeX + dx, -1, biomeZ + dz, Source.NOOP_CLIMATE_SAMPLER);
                biomeBuffer.set(dx, dz, (Holder<Biome>)biome);
            }
        }
        for (int i = heightAccessor.getMinSection(); i < heightAccessor.getMaxSection(); ++i) {
            LevelChunkSection chunkSection = chunk.getSection(chunk.getSectionIndexFromSectionY(i));
            ChunkUtil.fillSectionBiomes(chunkSection, biomeBuffer, i);
        }
    }

    private static void fillSectionBiomes(LevelChunkSection section, BiomeBuffer2D buffer, int sectionY) {
        section.fillBiomesFromNoise((BiomeResolver)buffer, Source.NOOP_CLIMATE_SAMPLER, 0, sectionY * 4, 0);
    }

    public static void fillChunk(int seaLevel, ChunkAccess chunk, TerrainData terrainData, GeneratorResource resource) {
        LevelChunkSection section;
        int index;
        int sy;
        int limit = chunk.getMaxBuildHeight();
        int min = Math.min(limit, ChunkUtil.getLowestSection(terrainData));
        int max = Math.min(limit, ChunkUtil.getHighestSection(terrainData));
        int worldX = chunk.getPos().getMinBlockX();
        int worldZ = chunk.getPos().getMinBlockZ();
        FriendlyByteBuf sectionData = resource.fullSection;
        for (sy = chunk.getMinBuildHeight(); sy < min; sy += 16) {
            index = chunk.getSectionIndex(sy);
            section = chunk.getSection(index);
            sectionData.resetReaderIndex();
            section.getStates().read(sectionData);
            section.recalcBlockCounts();
        }
        for (sy = min; sy <= max; sy += 16) {
            index = chunk.getSectionIndex(sy);
            section = chunk.getSection(index);
            ChunkUtil.fillSectionTerrain(sy, seaLevel, terrainData, section, worldX, worldZ);
        }
    }

    public static void fillChunk(int seaLevel, ChunkAccess chunk, TerrainData terrainData, FillerBlock filler, GeneratorResource resource) {
        LevelChunkSection section;
        int index;
        int sy;
        int limit = chunk.getMaxBuildHeight();
        int min = Math.min(limit, ChunkUtil.getLowestSection(terrainData));
        int max = Math.min(limit, ChunkUtil.getHighestSection(terrainData));
        FriendlyByteBuf sectionData = resource.fullSection;
        for (sy = chunk.getMinBuildHeight(); sy < min; sy += 16) {
            index = chunk.getSectionIndex(sy);
            section = chunk.getSection(index);
            sectionData.resetReaderIndex();
            section.getStates().read(sectionData);
            section.recalcBlockCounts();
        }
        for (sy = min; sy <= max; sy += 16) {
            index = chunk.getSectionIndex(sy);
            section = chunk.getSection(index);
            ChunkUtil.fillSectionLegacy(sy, seaLevel, terrainData, section, filler);
        }
    }

    private static void fillSectionTerrain(int startY, int seaLevel, TerrainData terrainData, LevelChunkSection section, int worldX, int worldZ) {
        section.acquire();
        int sectionMaxY = startY + 16;
        for (int lz = 0; lz < 16; ++lz) {
            for (int lx = 0; lx < 16; ++lx) {
                int wx = worldX + lx;
                int wz = worldZ + lz;
                int solidY = terrainData.getHeight(lx, lz);
                int waterY = TerrainLevels.getWaterLevel(lx, lz, seaLevel, terrainData);
                Terrain terrain = terrainData.getTerrain().get(lx, lz);
                int heightAboveSea = solidY - seaLevel;
                float beachFactor = ChunkUtil.computeBeachFactor(terrain, heightAboveSea, wx, wz);
                int effectiveSolidY = solidY;
                if (beachFactor > 0.01f) {
                    effectiveSolidY = ChunkUtil.blendBeachHeight(wx, wz, solidY, seaLevel, beachFactor);
                }
                boolean underwater = effectiveSolidY < waterY;
                int firstAirY = Math.max(effectiveSolidY, waterY) + 1;
                int exclusiveMaxY = Math.min(sectionMaxY, firstAirY);
                float steepness = ChunkUtil.computeSteepnessWeighted(lx, lz, heightAboveSea, terrainData);
                MountainLevel mountainLevel = ChunkUtil.getMountainLevel(terrain, heightAboveSea, wx, wz);
                for (int y = startY; y < exclusiveMaxY; ++y) {
                    BlockState state = ChunkUtil.getBlockForColumn(wx, wz, y, effectiveSolidY, waterY, underwater, steepness, heightAboveSea, mountainLevel, beachFactor);
                    section.setBlockState(lx, y & 0xF, lz, state, false);
                }
            }
        }
        section.release();
    }

    private static BlockState getBlockForColumn(int wx, int wz, int y, int solidY, int waterY, boolean underwater, float steepness, int heightAboveSea, MountainLevel mountainLevel, float beachFactor) {
        if (y > solidY) {
            return y <= waterY ? WATER : AIR;
        }
        if (beachFactor > 0.01f) {
            BlockState beachState = ChunkUtil.getBeachBlock(wx, wz, y, solidY, waterY);
            if (beachFactor > 0.95f) {
                return beachState;
            }
            BlockState normalState = ChunkUtil.getNormalBlock(wx, wz, y, solidY, waterY, underwater, steepness, heightAboveSea, mountainLevel);
            float n = ChunkUtil.valueNoise((float)wx * 0.13f + (float)wz * 0.07f, (float)wz * 0.11f - (float)wx * 0.05f, 44444);
            return n < beachFactor ? beachState : normalState;
        }
        return ChunkUtil.getNormalBlock(wx, wz, y, solidY, waterY, underwater, steepness, heightAboveSea, mountainLevel);
    }

    private static BlockState getNormalBlock(int wx, int wz, int y, int solidY, int waterY, boolean underwater, float steepness, int heightAboveSea, MountainLevel mountainLevel) {
        if (underwater) {
            return ChunkUtil.getUnderwaterBlock(wx, wz, y, solidY, waterY);
        }
        if (y == solidY) {
            return ChunkUtil.getSurfaceBlock(wx, wz, steepness, solidY, heightAboveSea, mountainLevel);
        }
        if (y > solidY - 4) {
            return ChunkUtil.getSubSurfaceBlock(wx, wz, y, steepness, mountainLevel);
        }
        if (mountainLevel == MountainLevel.PEAKS || mountainLevel == MountainLevel.ALPINE) {
            return ChunkUtil.getDeepMountainBlock(wx, wz, y);
        }
        return STONE;
    }

    private static float computeBeachFactor(Terrain terrain, int heightAboveSea, int wx, int wz) {
        if (terrain != null) {
            String name = terrain.getName().toLowerCase();
            if (name.contains("beach")) {
                return 1.0f;
            }
            if (name.contains("coast")) {
                return 0.6f;
            }
        }
        if (heightAboveSea < 0 || heightAboveSea > 6) {
            return 0.0f;
        }
        float n1 = ChunkUtil.valueNoise((float)wx * 0.023f, (float)wz * 0.023f, 11111);
        float n2 = ChunkUtil.valueNoise((float)wx * 0.071f, (float)wz * 0.071f, 22222);
        float n3 = ChunkUtil.valueNoise((float)wx * 0.157f, (float)wz * 0.157f, 33333);
        float combined = n1 * 0.5f + n2 * 0.3f + n3 * 0.2f;
        if (heightAboveSea <= 1) {
            return 0.7f + combined * 0.3f;
        }
        if (heightAboveSea <= 3) {
            float fade = 1.0f - (float)(heightAboveSea - 1) / 3.0f;
            return fade * (0.3f + combined * 0.6f);
        }
        float fade = 1.0f - (float)(heightAboveSea - 3) / 4.0f;
        return Math.max(0.0f, fade * combined * 0.2f);
    }

    private static int blendBeachHeight(int wx, int wz, int originalHeight, int seaLevel, float beachFactor) {
        int heightAboveSea = originalHeight - seaLevel;
        if (heightAboveSea <= 1) {
            return originalHeight;
        }
        float n1 = ChunkUtil.valueNoise((float)wx * 0.019f, (float)wz * 0.019f, 12121);
        float n2 = ChunkUtil.valueNoise((float)wx * 0.053f, (float)wz * 0.053f, 34343);
        float n3 = ChunkUtil.valueNoise((float)wx * 0.131f, (float)wz * 0.131f, 56565);
        float heightNoise = n1 * 0.5f + n2 * 0.3f + n3 * 0.2f;
        int targetHeight = seaLevel + 1 + Math.round(heightNoise * 1.5f);
        float effectiveFactor = beachFactor * 0.6f;
        float blended = (float)originalHeight * (1.0f - effectiveFactor) + (float)targetHeight * effectiveFactor;
        return Math.max(seaLevel, Math.round(blended));
    }

    private static BlockState getBeachBlock(int wx, int wz, int y, int solidY, int waterY) {
        if (y > solidY) {
            return y <= waterY ? WATER : AIR;
        }
        float surfN = ChunkUtil.valueNoise((float)wx * 0.09f, (float)wz * 0.09f, 56565);
        float detailN = ChunkUtil.valueNoise((float)wx * 0.31f, (float)wz * 0.31f, 78787);
        float combined = surfN * 0.6f + detailN * 0.4f;
        if (y == solidY) {
            if (combined > 0.93f) {
                return GRAVEL;
            }
            if (combined > 0.88f) {
                return COARSE_DIRT;
            }
            return SAND;
        }
        if (y > solidY - 3) {
            return SAND;
        }
        if (y > solidY - 5) {
            float n = ChunkUtil.valueNoise((float)wx * 0.07f, (float)wz * 0.07f, y * 77 + 89898);
            return n < 0.65f ? SANDSTONE : SAND;
        }
        return STONE;
    }

    private static MountainLevel getMountainLevel(Terrain terrain, int heightAboveSea, int wx, int wz) {
        int foothillsBase;
        int alpineBase;
        int peaksBase;
        boolean isMountainTerrain = false;
        if (terrain != null) {
            String name = terrain.getName().toLowerCase();
            boolean bl = isMountainTerrain = name.contains("mountain") || name.contains("volcano") || name.contains("ridge") || name.contains("dolomite") || name.contains("plateau") || name.contains("torridonian");
        }
        if (isMountainTerrain) {
            peaksBase = 80;
            alpineBase = 50;
            foothillsBase = 25;
        } else {
            peaksBase = 110;
            alpineBase = 80;
            foothillsBase = 55;
        }
        float noiseOffset = (ChunkUtil.valueNoise((float)wx * 0.031f, (float)wz * 0.031f, 88888) - 0.5f) * 30.0f;
        float effectiveHeight = (float)heightAboveSea + noiseOffset;
        if (effectiveHeight > (float)peaksBase) {
            return MountainLevel.PEAKS;
        }
        if (effectiveHeight > (float)alpineBase) {
            return MountainLevel.ALPINE;
        }
        if (effectiveHeight > (float)foothillsBase) {
            return MountainLevel.FOOTHILLS;
        }
        return MountainLevel.NONE;
    }

    private static BlockState getSurfaceBlock(int wx, int wz, float steepness, int surfaceY, int heightAboveSea, MountainLevel mountainLevel) {
        return switch (mountainLevel.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> ChunkUtil.getMountainSurface(wx, wz, surfaceY, heightAboveSea);
            case 2 -> {
                float alpineFactor = Math.min(1.0f, Math.max(0.0f, ((float)heightAboveSea - 40.0f) / 40.0f));
                float n = ChunkUtil.valueNoise((float)wx * 0.06f, (float)wz * 0.06f, 91919);
                float threshold = 0.3f + (1.0f - alpineFactor) * 0.5f;
                if (steepness < 0.15f && n < threshold) {
                    yield GRASS_BLOCK;
                }
                if (n < threshold * 0.5f && steepness < 0.3f) {
                    yield COARSE_DIRT;
                }
                yield ChunkUtil.getMountainSurface(wx, wz, surfaceY, heightAboveSea);
            }
            case 1 -> {
                float footFactor = Math.min(1.0f, Math.max(0.0f, ((float)heightAboveSea - 20.0f) / 35.0f));
                float n = ChunkUtil.valueNoise((float)wx * 0.05f, (float)wz * 0.05f, 73737);
                if (n < footFactor * 0.4f && steepness > 0.3f) {
                    yield ChunkUtil.getMountainSurface(wx, wz, surfaceY, heightAboveSea);
                }
                yield ChunkUtil.getGradientSurface(wx, wz, steepness + footFactor * 0.15f, surfaceY);
            }
            case 0 -> ChunkUtil.getGradientSurface(wx, wz, steepness, surfaceY);
        };
    }

    private static BlockState getMountainSurface(int wx, int wz, int y, int heightAboveSea) {
        float n1 = ChunkUtil.valueNoise((float)wx * 0.037f, (float)wz * 0.037f, 10101);
        float n2 = ChunkUtil.valueNoise((float)wx * 0.091f, (float)wz * 0.091f, 20202);
        float n = n1 * 0.6f + n2 * 0.4f;
        if (heightAboveSea > 120) {
            if (n < 0.4f) {
                return SNOW_BLOCK;
            }
            if (n < 0.55f) {
                return STONE;
            }
            return PACKED_ICE;
        }
        if (n < 0.3f) {
            return STONE;
        }
        if (n < 0.5f) {
            return ANDESITE;
        }
        if (n < 0.68f) {
            return DIORITE;
        }
        if (n < 0.82f) {
            return GRANITE;
        }
        if (n < 0.92f) {
            return COBBLESTONE;
        }
        return COARSE_DIRT;
    }

    private static BlockState getGradientSurface(int wx, int wz, float steepness, int surfaceY) {
        float grassMax = 0.52f;
        float stoneMin = 0.78f;
        if (steepness < grassMax) {
            return GRASS_BLOCK;
        }
        if (steepness > stoneMin) {
            return STONE;
        }
        float blend = (steepness - grassMax) / (stoneMin - grassMax);
        float noise = ChunkUtil.valueNoise((float)wx * 0.11f, (float)wz * 0.11f, surfaceY + 45678);
        return noise < blend ? STONE : GRASS_BLOCK;
    }

    private static BlockState getSubSurfaceBlock(int wx, int wz, int y, float steepness, MountainLevel mountainLevel) {
        if (mountainLevel == MountainLevel.PEAKS) {
            return ChunkUtil.getDeepMountainBlock(wx, wz, y);
        }
        if (mountainLevel == MountainLevel.ALPINE) {
            float n = ChunkUtil.valueNoise((float)wx * 0.05f, (float)wz * 0.05f, y * 7 + 55555);
            return n < 0.3f ? DIRT : STONE;
        }
        if (steepness > 0.65f) {
            return STONE;
        }
        return DIRT;
    }

    private static BlockState getDeepMountainBlock(int wx, int wz, int y) {
        float n = ChunkUtil.valueNoise((float)wx * 0.04f, (float)wz * 0.04f, y * 11 + 66666);
        if (n < 0.6f) {
            return STONE;
        }
        if (n < 0.75f) {
            return ANDESITE;
        }
        if (n < 0.88f) {
            return DIORITE;
        }
        return GRANITE;
    }

    private static BlockState getUnderwaterBlock(int wx, int wz, int y, int solidY, int waterY) {
        if (y == solidY) {
            int depth = waterY - solidY;
            if (depth <= 4) {
                float n = ChunkUtil.valueNoise((float)wx * 0.09f, (float)wz * 0.09f, 77777);
                return n < 0.85f ? SAND : GRAVEL;
            }
            return GRAVEL;
        }
        if (y > solidY - 3) {
            return SAND;
        }
        return STONE;
    }

    private static float computeSteepnessWeighted(int lx, int lz, int heightAboveSea, TerrainData terrainData) {
        float raw = ChunkUtil.computeSteepnessSobel(lx, lz, terrainData);
        if (heightAboveSea < 20) {
            float suppress = 0.3f * (1.0f - (float)heightAboveSea / 20.0f);
            raw = Math.max(0.0f, raw - suppress) * (0.5f + 0.5f * ((float)heightAboveSea / 20.0f));
        } else if (heightAboveSea < 40) {
            float t = (float)(heightAboveSea - 20) / 20.0f;
            float suppress = 0.1f * (1.0f - t);
            raw = Math.max(0.0f, raw - suppress);
        }
        return raw;
    }

    private static float computeSteepnessSobel(int lx, int lz, TerrainData terrainData) {
        int h = terrainData.getHeight(lx, lz);
        int hN = ChunkUtil.getHeightSafe(lx, lz - 1, h, terrainData);
        int hS = ChunkUtil.getHeightSafe(lx, lz + 1, h, terrainData);
        int hW = ChunkUtil.getHeightSafe(lx - 1, lz, h, terrainData);
        int hE = ChunkUtil.getHeightSafe(lx + 1, lz, h, terrainData);
        int hNW = ChunkUtil.getHeightSafe(lx - 1, lz - 1, h, terrainData);
        int hNE = ChunkUtil.getHeightSafe(lx + 1, lz - 1, h, terrainData);
        int hSW = ChunkUtil.getHeightSafe(lx - 1, lz + 1, h, terrainData);
        int hSE = ChunkUtil.getHeightSafe(lx + 1, lz + 1, h, terrainData);
        float gx = (float)hNE + 2.0f * (float)hE + (float)hSE - ((float)hNW + 2.0f * (float)hW + (float)hSW);
        float gz = (float)hSW + 2.0f * (float)hS + (float)hSE - ((float)hNW + 2.0f * (float)hN + (float)hNE);
        float gradient = (float)Math.sqrt(gx * gx + gz * gz);
        return Math.min(1.0f, gradient / 32.0f);
    }

    private static int getHeightSafe(int x, int z, int fallback, TerrainData terrainData) {
        if (x >= -1 && x <= 16 && z >= -1 && z <= 16) {
            return terrainData.getHeight(x, z);
        }
        return fallback;
    }

    public static float valueNoise(float fx, float fz, int seed) {
        int ix = ChunkUtil.floor(fx);
        int iz = ChunkUtil.floor(fz);
        float fracX = fx - (float)ix;
        float fracZ = fz - (float)iz;
        float sx = fracX * fracX * (3.0f - 2.0f * fracX);
        float sz = fracZ * fracZ * (3.0f - 2.0f * fracZ);
        float v00 = ChunkUtil.hashFloat(ix, iz, seed);
        float v10 = ChunkUtil.hashFloat(ix + 1, iz, seed);
        float v01 = ChunkUtil.hashFloat(ix, iz + 1, seed);
        float v11 = ChunkUtil.hashFloat(ix + 1, iz + 1, seed);
        float top = v00 + sx * (v10 - v00);
        float bot = v01 + sx * (v11 - v01);
        return top + sz * (bot - top);
    }

    private static float hashFloat(int x, int z, int seed) {
        int h = seed;
        h ^= x * 1619;
        h ^= z * 31337;
        h = h * h * h * 60493;
        h = h >> 13 ^ h;
        return (float)(h & Integer.MAX_VALUE) / 2.1474836E9f;
    }

    private static int floor(float v) {
        int i = (int)v;
        return v < (float)i ? i - 1 : i;
    }

    public static void primeHeightmaps(int seaLevel, ChunkAccess chunk, TerrainData terrainData, FillerBlock filler) {
        Heightmap oceanFloor = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurface = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int floor = terrainData.getHeight(x, z);
                int surface = Math.max(seaLevel, floor);
                BlockState surfaceBlock = filler.getState(surface, floor);
                oceanFloor.update(x, floor, z, STONE);
                worldSurface.update(x, surface, z, surfaceBlock);
            }
        }
    }

    public static void buildStructureTerrain(ChunkAccess chunk, TerrainData terrainData, StructureManager structureFeatures) {
        int x = chunk.getPos().getMinBlockX();
        int z = chunk.getPos().getMinBlockZ();
        StructureTerrain operation = new StructureTerrain(chunk, structureFeatures);
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                operation.modify(x + dx, z + dz, chunk, terrainData);
            }
        }
    }

    private static void fillSectionLegacy(int startY, int seaLevel, TerrainData terrainData, LevelChunkSection section, FillerBlock filler) {
        section.acquire();
        int sectionMaxY = startY + 16;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int solidY = terrainData.getHeight(x, z);
                int waterY = TerrainLevels.getWaterLevel(x, z, seaLevel, terrainData);
                int exclusiveMaxY = Math.min(sectionMaxY, Math.max(solidY, waterY) + 1);
                for (int y = startY; y < exclusiveMaxY; ++y) {
                    section.setBlockState(x, y & 0xF, z, filler.getState(y, solidY), false);
                }
            }
        }
        section.release();
    }

    protected static BlockState getSimpleFiller(int y, int surfaceSolid) {
        if (y > surfaceSolid) {
            return WATER;
        }
        if (y == surfaceSolid) {
            return GRASS_BLOCK;
        }
        if (y > surfaceSolid - 4) {
            return DIRT;
        }
        return STONE;
    }

    protected static int getHighestSection(TerrainData terrainData) {
        return Math.max(terrainData.getMaxBase(), terrainData.getMax()) >> 4 << 4;
    }

    protected static int getLowestSection(TerrainData terrainData) {
        return terrainData.getMin() >> 4 << 4;
    }

    protected static ByteBuf createFullPalette() {
        IdMapper stateRegistry = Block.BLOCK_STATE_REGISTRY;
        PalettedContainer container = new PalettedContainer((IdMap)stateRegistry, (Object)STONE, PalettedContainer.Strategy.SECTION_STATES);
        container.acquire();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    container.getAndSetUnchecked(x, y, z, (Object)STONE);
                }
            }
        }
        container.release();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        container.write(buffer);
        return buffer;
    }

    public static FriendlyByteBuf getFullSection() {
        return new FriendlyByteBuf(FULL_SECTION.get().copy());
    }

    public static interface FillerBlock {
        public BlockState getState(int var1, int var2);
    }

    private static enum MountainLevel {
        NONE,
        FOOTHILLS,
        ALPINE,
        PEAKS;

    }
}

