/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.worldgen.util;

import com.terrano.mod.util.ReflectionUtil;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.Seeds;
import com.terrano.mod.worldgen.VanillaGen;
import com.terrano.mod.worldgen.terrain.TerrainData;
import com.terrano.mod.worldgen.util.NoopNoise;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class NoiseChunkUtil {
    private static final MethodHandle SURFACE_CACHE = ReflectionUtil.field(NoiseChunk.class, Long2IntMap.class, new String[0]);

    public static NoiseChunk getNoiseChunk(ChunkAccess chunk, RandomState state, Generator generator) {
        CompletableFuture<TerrainData> terrainData = generator.getChunkDataAsync(Seeds.get(state), chunk.getPos());
        NoiseChunk noiseChunk = chunk.getOrCreateNoiseChunk(c -> {
            VanillaGen vanilla = generator.getVanillaGen();
            Aquifer.FluidPicker fluidPicker = vanilla.getGlobalFluidPicker();
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)vanilla.getSettings().value();
            return NoiseChunk.forChunk((ChunkAccess)c, (RandomState)state, (DensityFunctions.BeardifierOrMarker)NoopNoise.BEARDIFIER, (NoiseGeneratorSettings)settings, (Aquifer.FluidPicker)fluidPicker, (Blender)Blender.empty());
        });
        NoiseChunkUtil.initChunk(chunk, noiseChunk, terrainData);
        return noiseChunk;
    }

    private static void initChunk(ChunkAccess chunk, NoiseChunk noiseChunk, CompletableFuture<TerrainData> terrainData) {
        Long2IntMap cache = NoiseChunkUtil.getCache(noiseChunk);
        if (!cache.isEmpty()) {
            return;
        }
        NoiseChunkUtil.initSurfaceCache(chunk, cache, terrainData);
    }

    private static void initSurfaceCache(ChunkAccess chunk, Long2IntMap cache, CompletableFuture<TerrainData> terrainData) {
        int dx;
        int dz;
        ChunkPos chunkPos = chunk.getPos();
        TerrainData data = terrainData.join();
        int startX = chunkPos.getMinBlockX();
        int startZ = chunkPos.getMinBlockZ();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        cache.clear();
        for (dz = 0; dz < 16; dz += 4) {
            for (dx = 0; dx < 16; dx += 4) {
                int height = data.getHeight(dx, dz);
                int qx = QuartPos.toBlock((int)QuartPos.fromBlock((int)(startX + dx)));
                int qz = QuartPos.toBlock((int)QuartPos.fromBlock((int)(startZ + dz)));
                long index = ColumnPos.asLong((int)qx, (int)qz);
                cache.put(index, height);
                min = Math.min(min, height);
                max = Math.max(max, height);
            }
        }
        for (dz = -16; dz < 32; dz += 4) {
            for (dx = -16; dx < 32; dx += 4) {
                if ((dx & 0xF) == dx && (dz & 0xF) == dz) continue;
                int qx = QuartPos.toBlock((int)QuartPos.fromBlock((int)(startX + dx)));
                int qz = QuartPos.toBlock((int)QuartPos.fromBlock((int)(startZ + dz)));
                long index = ColumnPos.asLong((int)qx, (int)qz);
                cache.put(index, min);
            }
        }
    }

    private static Long2IntMap getCache(NoiseChunk noiseChunk) {
        try {
            return SURFACE_CACHE.invokeExact(noiseChunk);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

