/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.domain;

import com.terrano.cereal.spec.Context;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.cereal.value.DataObject;
import com.terrano.noise.domain.Domain;

public class CompoundWarp
implements Domain {
    private final Domain a;
    private final Domain b;

    public CompoundWarp(Domain a, Domain b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public String getSpecName() {
        return "CompoundWarp";
    }

    @Override
    public float getOffsetX(float x, float y) {
        float ax = this.a.getX(x, y);
        float ay = this.a.getY(x, y);
        return this.b.getOffsetX(ax, ay);
    }

    @Override
    public float getOffsetY(float x, float y) {
        float ax = this.a.getX(x, y);
        float ay = this.a.getY(x, y);
        return this.b.getOffsetY(ax, ay);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CompoundWarp that = (CompoundWarp)o;
            return !this.a.equals(that.a) ? false : this.b.equals(that.b);
        }
        return false;
    }

    public int hashCode() {
        int result = this.a.hashCode();
        result = 31 * result + this.b.hashCode();
        return result;
    }

    private static CompoundWarp create(DataObject data, DataSpec<?> spec, Context context) {
        return new CompoundWarp(spec.get("warp_1", data, Domain.class, context), spec.get("warp_2", data, Domain.class, context));
    }

    public static DataSpec<? extends Domain> spec() {
        return DataSpec.builder("CumulativeWarp", CompoundWarp.class, CompoundWarp::create).addObj("warp_1", Domain.class, w -> w.a).addObj("warp_2", Domain.class, w -> w.b).build();
    }
}

