/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.func;

import com.terrano.cereal.spec.DataFactory;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.noise.func.CurveFunc;
import com.terrano.noise.util.NoiseUtil;
import java.util.function.Function;

public enum Interpolation implements CurveFunc
{
    LINEAR{

        @Override
        public float apply(float f) {
            return f;
        }
    }
    ,
    CURVE3{

        @Override
        public float apply(float f) {
            return NoiseUtil.interpHermite(f);
        }
    }
    ,
    CURVE4{

        @Override
        public float apply(float f) {
            return NoiseUtil.interpQuintic(f);
        }
    };

    private static final DataFactory<Interpolation> factory;

    private Interpolation() {
    }

    @Override
    public String getSpecName() {
        return "Interpolation";
    }

    @Override
    public abstract float apply(float var1);

    public static DataSpec<Interpolation> spec() {
        return DataSpec.builder("Interpolation", Interpolation.class, factory).add("mode", (Object)LINEAR, Function.identity()).build();
    }

    private Interpolation(Object x2) {
        this();
    }

    static {
        factory = (data, spec, context) -> spec.getEnum("mode", data, Interpolation.class);
    }
}

