/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.modifier;

import com.terrano.cereal.spec.DataSpec;
import com.terrano.noise.Module;
import com.terrano.noise.modifier.Modifier;

public class Cache
extends Modifier {
    private final Value value = new Value();

    public Cache(Module source) {
        super(source);
    }

    @Override
    public String getSpecName() {
        return "Cache";
    }

    @Override
    public float minValue() {
        return this.source.minValue();
    }

    @Override
    public float maxValue() {
        return this.source.maxValue();
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        return 0.0f;
    }

    @Override
    public float getValue(float x, float y) {
        Value value = this.value;
        return value.matches(x, y) ? value.value : value.set(x, y, this.source.getValue(x, y));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            Cache cache = (Cache)o;
            return this.value.equals(cache.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public static DataSpec<Cache> spec() {
        return Cache.spec(Cache.class, Cache::new);
    }

    private static class Value {
        private float x = 0.0f;
        private float y = 0.0f;
        private float value = 0.0f;
        private boolean empty = true;

        private Value() {
        }

        private boolean matches(float x, float y) {
            return !this.empty && x == this.x && y == this.y;
        }

        private float set(float x, float y, float value) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.empty = false;
            return value;
        }

        Value(Object x0) {
            this();
        }
    }
}

