/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.modifier;

import com.terrano.cereal.spec.DataFactory;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.noise.Module;
import com.terrano.noise.func.CurveFunc;
import com.terrano.noise.func.MidPointCurve;
import com.terrano.noise.modifier.Modifier;

public class Curve
extends Modifier {
    private final CurveFunc func;
    private static final DataFactory<Curve> factory = (data, spec, context) -> new Curve(spec.get("source", data, Module.class, context), spec.get("curve", data, CurveFunc.class, context));

    public Curve(Module source, CurveFunc func) {
        super(source);
        this.func = func;
    }

    public Curve(Module source, float mid, float steepness) {
        this(source, new MidPointCurve(mid, steepness));
    }

    @Override
    public String getSpecName() {
        return "Curve";
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        return this.func.apply(noiseValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            Curve curve = (Curve)o;
            return this.func.equals(curve.func);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.func.hashCode();
        return result;
    }

    public static DataSpec<Curve> spec() {
        return Curve.sourceBuilder(Curve.class, factory).addObj("curve", CurveFunc.class, c -> c.func).build();
    }
}

