/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.modifier;

import com.terrano.cereal.spec.DataFactory;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.noise.Module;
import com.terrano.noise.modifier.Modifier;

public class Freq
extends Modifier {
    private final Module x;
    private final Module y;
    private static final DataFactory<Freq> factory = (data, spec, context) -> new Freq(spec.get("source", data, Module.class, context), spec.get("x", data, Module.class, context), spec.get("y", data, Module.class, context));

    public Freq(Module source, Module x, Module y) {
        super(source);
        this.x = x;
        this.y = y;
    }

    @Override
    public String getSpecName() {
        return "Freq";
    }

    @Override
    public float getValue(float x, float y) {
        float fx = this.x.getValue(x, y);
        float fy = this.y.getValue(x, y);
        return this.source.getValue(x * fx, y * fy);
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        return 0.0f;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            Freq freq = (Freq)o;
            return !this.x.equals(freq.x) ? false : this.y.equals(freq.y);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.x.hashCode();
        result = 31 * result + this.y.hashCode();
        return result;
    }

    public static DataSpec<Freq> spec() {
        return Freq.sourceBuilder(Freq.class, factory).addObj("x", Module.class, f -> f.x).addObj("y", Module.class, f -> f.y).build();
    }
}

