/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.noise.modifier;

import com.terrano.cereal.spec.DataFactory;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.noise.Module;
import com.terrano.noise.modifier.Modifier;

public class Threshold
extends Modifier {
    private final Module threshold;
    private static final DataFactory<Threshold> factory = (data, spec, context) -> new Threshold(spec.get("source", data, Module.class, context), spec.get("threshold", data, Module.class, context));

    public Threshold(Module source, Module threshold) {
        super(source);
        this.threshold = threshold;
    }

    @Override
    public String getSpecName() {
        return "Threshold";
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        float limit = this.threshold.getValue(x, y);
        return noiseValue < limit ? 0.0f : 1.0f;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            Threshold threshold1 = (Threshold)o;
            return this.threshold.equals(threshold1.threshold);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.threshold.hashCode();
        return result;
    }

    public static DataSpec<Threshold> spec() {
        return Modifier.sourceBuilder(Threshold.class, factory).addObj("threshold", Module.class, t -> t.threshold).build();
    }
}

