/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.quickinvmove.client.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;

public final class QuickInvMoveClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue DEFAULT_BOX_SELECT_ADD = BUILDER.comment("Default box-select mode. false=replace, true=add").define("defaultBoxSelectAdd", false);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXTRA_BLOCKED_SLOT_CLASS_NAMES = BUILDER.comment("Extra blocked slot class names (fully qualified)").defineList("extraBlockedSlotClassNames", List.of(), QuickInvMoveClientConfig::isValidToken);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXTRA_BLOCKED_SLOT_SIMPLE_NAMES = BUILDER.comment("Extra blocked slot simple class names").defineList("extraBlockedSlotSimpleNames", List.of(), QuickInvMoveClientConfig::isValidToken);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXTRA_ALLOWED_SLOT_CLASS_NAMES = BUILDER.comment("Extra allowed slot class names (fully qualified)").defineList("extraAllowedSlotClassNames", List.of(), QuickInvMoveClientConfig::isValidToken);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXTRA_ALLOWED_SLOT_SIMPLE_NAMES = BUILDER.comment("Extra allowed slot simple class names").defineList("extraAllowedSlotSimpleNames", List.of(), QuickInvMoveClientConfig::isValidToken);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXTRA_BLOCKED_SLOT_NAME_KEYWORDS = BUILDER.comment("Extra blocked slot name keywords").defineList("extraBlockedSlotNameKeywords", List.of(), QuickInvMoveClientConfig::isValidToken);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    private QuickInvMoveClientConfig() {
    }

    public static boolean defaultBoxSelectAdd() {
        return (Boolean)DEFAULT_BOX_SELECT_ADD.get();
    }

    public static Set<String> extraBlockedSlotClassNames() {
        return QuickInvMoveClientConfig.normalize((List)EXTRA_BLOCKED_SLOT_CLASS_NAMES.get(), false);
    }

    public static Set<String> extraBlockedSlotSimpleNames() {
        return QuickInvMoveClientConfig.normalize((List)EXTRA_BLOCKED_SLOT_SIMPLE_NAMES.get(), false);
    }

    public static Set<String> extraAllowedSlotClassNames() {
        return QuickInvMoveClientConfig.normalize((List)EXTRA_ALLOWED_SLOT_CLASS_NAMES.get(), false);
    }

    public static Set<String> extraAllowedSlotSimpleNames() {
        return QuickInvMoveClientConfig.normalize((List)EXTRA_ALLOWED_SLOT_SIMPLE_NAMES.get(), false);
    }

    public static Set<String> extraBlockedSlotNameKeywords() {
        return QuickInvMoveClientConfig.normalize((List)EXTRA_BLOCKED_SLOT_NAME_KEYWORDS.get(), true);
    }

    private static Set<String> normalize(List<? extends String> values, boolean lowercase) {
        LinkedHashSet<String> normalized = new LinkedHashSet<String>();
        for (String string : values) {
            String token;
            if (string == null || (token = string.trim()).isEmpty()) continue;
            normalized.add(lowercase ? token.toLowerCase(Locale.ROOT) : token);
        }
        return normalized;
    }

    private static boolean isValidToken(Object value) {
        String stringValue;
        return value instanceof String && !(stringValue = (String)value).isBlank();
    }
}

