/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.quickinvmove.client.selection;

import committee.nova.mods.quickinvmove.client.config.QuickInvMoveClientConfig;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class SlotSelectionRules {
    private static final Set<String> BLOCKED_SLOT_CLASS_NAMES = Set.of("net.minecraft.world.inventory.ResultSlot", "net.minecraft.world.inventory.FurnaceResultSlot", "net.minecraft.world.inventory.MerchantResultSlot");
    private static final Set<String> BLOCKED_SLOT_SIMPLE_NAMES = Set.of("ResultSlot", "FurnaceResultSlot", "MerchantResultSlot", "StonecutterResultSlot", "SmithingResultSlot", "GrindstoneResultSlot", "AnvilResultSlot", "TakeOnlySlot");
    private static final Set<String> BLOCKED_SLOT_NAME_KEYWORDS = Set.of("result", "output", "takeonly");
    private static final Set<String> ALLOWED_SLOT_SIMPLE_NAMES = Set.of("Slot", "SlotItemHandler");

    private SlotSelectionRules() {
    }

    public static boolean canSelect(@Nullable Slot slot, @Nullable Player player, boolean playerInventorySlot) {
        if (slot == null || player == null || !slot.m_6657_() || !slot.m_8010_(player)) {
            return false;
        }
        if (playerInventorySlot) {
            return true;
        }
        if (SlotSelectionRules.isLikelyOutputSlot(slot)) {
            return false;
        }
        ItemStack currentStack = slot.m_7993_();
        return slot.m_5857_(currentStack);
    }

    public static boolean isLikelyOutputSlot(Slot slot) {
        String fullName = slot.getClass().getName();
        if (SlotSelectionRules.matchesExact(fullName, BLOCKED_SLOT_CLASS_NAMES, QuickInvMoveClientConfig.extraBlockedSlotClassNames())) {
            return true;
        }
        if (SlotSelectionRules.matchesExact(fullName, QuickInvMoveClientConfig.extraAllowedSlotClassNames())) {
            return false;
        }
        String simpleName = slot.getClass().getSimpleName();
        if (SlotSelectionRules.matchesExact(simpleName, BLOCKED_SLOT_SIMPLE_NAMES, QuickInvMoveClientConfig.extraBlockedSlotSimpleNames())) {
            return true;
        }
        if (SlotSelectionRules.matchesExact(simpleName, ALLOWED_SLOT_SIMPLE_NAMES, QuickInvMoveClientConfig.extraAllowedSlotSimpleNames())) {
            return false;
        }
        String lowerName = simpleName.toLowerCase(Locale.ROOT);
        return SlotSelectionRules.containsKeyword(lowerName, BLOCKED_SLOT_NAME_KEYWORDS) || SlotSelectionRules.containsKeyword(lowerName, QuickInvMoveClientConfig.extraBlockedSlotNameKeywords());
    }

    private static boolean matchesExact(String value, Set<String> primary) {
        return primary.contains(value);
    }

    private static boolean matchesExact(String value, Set<String> primary, Set<String> secondary) {
        return primary.contains(value) || secondary.contains(value);
    }

    private static boolean containsKeyword(String lowerName, Set<String> keywords) {
        for (String keyword : keywords) {
            if (!lowerName.contains(keyword)) continue;
            return true;
        }
        return false;
    }
}

