/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.quickinvmove.init.mixins;

import committee.nova.mods.quickinvmove.client.QuickInvMoveClient;
import committee.nova.mods.quickinvmove.client.config.QuickInvMoveClientConfig;
import committee.nova.mods.quickinvmove.client.selection.BoxSelectMode;
import committee.nova.mods.quickinvmove.client.selection.SlotSelectionRules;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin {
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Shadow
    @Final
    protected AbstractContainerMenu f_97732_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97727_;
    @Shadow
    protected int f_97728_;
    @Shadow
    protected int f_97729_;
    @Unique
    private final Set<Integer> qimSelectedSlotIds = new LinkedHashSet<Integer>();
    @Unique
    private boolean qimIsBoxSelectCandidate;
    @Unique
    private boolean qimIsBoxSelecting;
    @Unique
    private int qimBoxCandidateSlotId = -999;
    @Unique
    private BoxSelectMode qimBoxSelectionMode = BoxSelectMode.REPLACE;
    @Unique
    private double qimBoxStartX;
    @Unique
    private double qimBoxStartY;
    @Unique
    private double qimBoxCurrentX;
    @Unique
    private double qimBoxCurrentY;
    @Unique
    private boolean qimIsMoveDragCandidate;
    @Unique
    private boolean qimIsMoveDragging;
    @Unique
    private int qimMoveCandidateSlotId = -999;
    @Unique
    private double qimMoveStartX;
    @Unique
    private double qimMoveStartY;
    @Unique
    private double qimCurrentMouseX;
    @Unique
    private double qimCurrentMouseY;
    @Unique
    private boolean qimDragSourcePlayerInventory;
    @Unique
    private final List<ItemStack> qimPreviewStacks = new ArrayList<ItemStack>();

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void qim$mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        this.qimCurrentMouseX = mouseX;
        this.qimCurrentMouseY = mouseY;
        Slot slot = this.f_97734_;
        if (button == 0 && Screen.m_96637_() && this.qimCanSelectSlot(slot)) {
            this.qimToggleSelection(slot);
            cir.setReturnValue((Object)true);
            return;
        }
        if (button == 1) {
            this.qimIsBoxSelectCandidate = true;
            this.qimIsBoxSelecting = false;
            this.qimBoxCandidateSlotId = this.qimSlotIdOrOutside(slot);
            this.qimBoxSelectionMode = this.qimResolveBoxSelectMode();
            this.qimBoxStartX = mouseX;
            this.qimBoxStartY = mouseY;
            this.qimBoxCurrentX = mouseX;
            this.qimBoxCurrentY = mouseY;
            cir.setReturnValue((Object)true);
            return;
        }
        if (button == 0 && slot != null && this.qimSelectedSlotIds.contains(this.qimSlotId(slot))) {
            this.qimIsMoveDragCandidate = true;
            this.qimIsMoveDragging = false;
            this.qimMoveCandidateSlotId = this.qimSlotIdOrOutside(slot);
            this.qimMoveStartX = mouseX;
            this.qimMoveStartY = mouseY;
            this.qimDragSourcePlayerInventory = this.qimIsPlayerInventorySlot(slot);
            this.qimPreviewStacks.clear();
            this.qimPreviewStacks.addAll(this.qimCollectPreviewStacks(this.qimDragSourcePlayerInventory));
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void qim$mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, CallbackInfoReturnable<Boolean> cir) {
        this.qimCurrentMouseX = mouseX;
        this.qimCurrentMouseY = mouseY;
        if (this.qimIsBoxSelectCandidate && button == 1) {
            this.qimBoxCurrentX = mouseX;
            this.qimBoxCurrentY = mouseY;
            if (!this.qimIsBoxSelecting && this.qimIsDragThresholdReached(this.qimBoxStartX, this.qimBoxStartY, mouseX, mouseY)) {
                this.qimIsBoxSelecting = true;
            }
            cir.setReturnValue((Object)true);
            return;
        }
        if ((this.qimIsMoveDragCandidate || this.qimIsMoveDragging) && button == 0) {
            if (!this.qimIsMoveDragging && this.qimIsDragThresholdReached(this.qimMoveStartX, this.qimMoveStartY, mouseX, mouseY)) {
                this.qimIsMoveDragging = true;
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void qim$mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        this.qimCurrentMouseX = mouseX;
        this.qimCurrentMouseY = mouseY;
        if (button == 1 && this.qimIsBoxSelectCandidate) {
            this.qimBoxCurrentX = mouseX;
            this.qimBoxCurrentY = mouseY;
            if (this.qimIsBoxSelecting) {
                this.qimSelectByRectangle();
            } else {
                this.qimReplayPickupClick(this.qimBoxCandidateSlotId, 1);
            }
            this.qimResetBoxSelectionState();
            cir.setReturnValue((Object)true);
            return;
        }
        if (button == 0 && (this.qimIsMoveDragCandidate || this.qimIsMoveDragging)) {
            if (this.qimIsMoveDragging) {
                this.qimMoveSelectedItems();
            } else {
                this.qimReplayPickupClick(this.qimMoveCandidateSlotId, 0);
            }
            this.qimResetMoveDragState();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void qim$keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (QuickInvMoveClient.isClearSelectionPressed(keyCode, scanCode)) {
            this.qimClearState();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void qim$removed(CallbackInfo ci) {
        this.qimClearState();
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void qim$render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.qimCurrentMouseX = mouseX;
        this.qimCurrentMouseY = mouseY;
        this.qimCleanupSelection();
        this.qimRenderSelectedSlots(guiGraphics);
        this.qimRenderSelectionCounter(guiGraphics);
        if (this.qimIsBoxSelecting) {
            this.qimRenderSelectBox(guiGraphics);
        }
        if (this.qimIsMoveDragging) {
            this.qimRenderDragPreview(guiGraphics);
        }
    }

    @Unique
    private void qimRenderSelectedSlots(GuiGraphics guiGraphics) {
        for (Integer slotId : this.qimSelectedSlotIds) {
            Slot slot = this.qimGetSlot(slotId);
            if (slot == null) continue;
            int x = this.f_97735_ + slot.f_40220_;
            int y = this.f_97736_ + slot.f_40221_;
            guiGraphics.m_280509_(x, y, x + 16, y + 16, 1430096895);
            guiGraphics.m_280509_(x, y, x + 16, y + 1, -9129217);
            guiGraphics.m_280509_(x, y + 15, x + 16, y + 16, -9129217);
            guiGraphics.m_280509_(x, y, x + 1, y + 16, -9129217);
            guiGraphics.m_280509_(x + 15, y, x + 16, y + 16, -9129217);
        }
    }

    @Unique
    private void qimRenderSelectionCounter(GuiGraphics guiGraphics) {
        if (this.qimSelectedSlotIds.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91062_ == null) {
            return;
        }
        MutableComponent selectedText = Component.m_237110_((String)"text.quickinvmove.selected_count", (Object[])new Object[]{this.qimSelectedSlotIds.size()});
        Objects.requireNonNull(minecraft.f_91062_);
        int lineHeight = 9;
        int hudWidth = minecraft.f_91062_.m_92852_((FormattedText)selectedText);
        int hudHeight = lineHeight;
        int hudX = this.f_97735_ + this.f_97726_ - hudWidth - 6;
        int hudY = this.f_97736_ + 6;
        Component title = ((Screen)this).m_96636_();
        int titleX = this.f_97735_ + this.f_97728_;
        int titleY = this.f_97736_ + this.f_97729_;
        int titleWidth = minecraft.f_91062_.m_92852_((FormattedText)title);
        if (this.qimRectsOverlap(hudX, hudY, hudX + hudWidth, hudY + hudHeight, titleX, titleY, titleX + titleWidth, titleY + lineHeight)) {
            hudY = titleY + lineHeight + 2;
        }
        guiGraphics.m_280614_(minecraft.f_91062_, (Component)selectedText, hudX, hudY, 0xFFFFFF, true);
    }

    @Unique
    private void qimRenderSelectBox(GuiGraphics guiGraphics) {
        int minX = (int)Math.min(this.qimBoxStartX, this.qimBoxCurrentX);
        int minY = (int)Math.min(this.qimBoxStartY, this.qimBoxCurrentY);
        int maxX = (int)Math.max(this.qimBoxStartX, this.qimBoxCurrentX);
        int maxY = (int)Math.max(this.qimBoxStartY, this.qimBoxCurrentY);
        guiGraphics.m_280509_(minX, minY, maxX + 1, maxY + 1, 574458879);
        guiGraphics.m_280509_(minX, minY, maxX + 1, minY + 1, -9129217);
        guiGraphics.m_280509_(minX, maxY, maxX + 1, maxY + 1, -9129217);
        guiGraphics.m_280509_(minX, minY, minX + 1, maxY + 1, -9129217);
        guiGraphics.m_280509_(maxX, minY, maxX + 1, maxY + 1, -9129217);
    }

    @Unique
    private void qimRenderDragPreview(GuiGraphics guiGraphics) {
        int displayCount = Math.min(this.qimPreviewStacks.size(), 4);
        int baseX = (int)this.qimCurrentMouseX + 10;
        int baseY = (int)this.qimCurrentMouseY + 8;
        for (int i = 0; i < displayCount; ++i) {
            ItemStack stack = this.qimPreviewStacks.get(i);
            guiGraphics.m_280203_(stack, baseX + i * 8, baseY + i * 8);
        }
        if (this.qimPreviewStacks.size() > displayCount) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91062_ != null) {
                MutableComponent extra = Component.m_237113_((String)("+" + (this.qimPreviewStacks.size() - displayCount)));
                guiGraphics.m_280614_(minecraft.f_91062_, (Component)extra, baseX + displayCount * 8, baseY + displayCount * 8, 0xFFFFFF, true);
            }
        }
    }

    @Unique
    private void qimSelectByRectangle() {
        if (this.qimBoxSelectionMode == BoxSelectMode.REPLACE) {
            this.qimSelectedSlotIds.clear();
        }
        double minX = Math.min(this.qimBoxStartX, this.qimBoxCurrentX);
        double minY = Math.min(this.qimBoxStartY, this.qimBoxCurrentY);
        double maxX = Math.max(this.qimBoxStartX, this.qimBoxCurrentX);
        double maxY = Math.max(this.qimBoxStartY, this.qimBoxCurrentY);
        for (int slotId = 0; slotId < this.f_97732_.f_38839_.size(); ++slotId) {
            Slot slot = this.qimGetSlot(slotId);
            if (!this.qimCanSelectSlot(slot)) continue;
            int centerX = this.f_97735_ + slot.f_40220_ + 8;
            int centerY = this.f_97736_ + slot.f_40221_ + 8;
            if (!((double)centerX >= minX) || !((double)centerX <= maxX) || !((double)centerY >= minY) || !((double)centerY <= maxY)) continue;
            this.qimSelectedSlotIds.add(slotId);
        }
    }

    @Unique
    private void qimMoveSelectedItems() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.f_91072_ == null) {
            return;
        }
        if (!this.f_97732_.m_142621_().m_41619_()) {
            return;
        }
        List<Integer> sourceSlotIds = this.qimCollectSourceSlotIds();
        if (sourceSlotIds.isEmpty()) {
            this.qimClearState();
            return;
        }
        if (this.qimDragSourcePlayerInventory) {
            for (Integer slotId : sourceSlotIds) {
                minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, slotId.intValue(), 0, ClickType.QUICK_MOVE, (Player)player);
            }
            if (!this.f_97732_.m_142621_().m_41619_() && !this.qimTryReturnCarriedToSource(sourceSlotIds, minecraft, (Player)player)) {
                minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, -999, 1, ClickType.THROW, (Player)player);
            }
        } else {
            this.qimMoveFromContainerToPlayer(sourceSlotIds, minecraft, (Player)player);
        }
        this.qimClearState();
    }

    @Unique
    private List<Integer> qimCollectSourceSlotIds() {
        ArrayList<Integer> sourceSlotIds = new ArrayList<Integer>();
        for (Integer slotId : this.qimSelectedSlotIds) {
            Slot slot = this.qimGetSlot(slotId);
            if (!this.qimCanMoveSlot(slot) || this.qimIsPlayerInventorySlot(slot) != this.qimDragSourcePlayerInventory) continue;
            sourceSlotIds.add(slotId);
        }
        return sourceSlotIds;
    }

    @Unique
    private void qimMoveFromContainerToPlayer(List<Integer> sourceSlotIds, Minecraft minecraft, Player player) {
        List<Integer> targetSlotIds = this.qimCollectPlayerStorageSlots();
        for (Integer sourceSlotId : sourceSlotIds) {
            this.qimMoveContainerSlotToPlayer(sourceSlotId, targetSlotIds, minecraft, player);
        }
        if (!this.f_97732_.m_142621_().m_41619_()) {
            minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, -999, 1, ClickType.THROW, player);
        }
    }

    @Unique
    private void qimMoveContainerSlotToPlayer(int sourceSlotId, List<Integer> targetSlotIds, Minecraft minecraft, Player player) {
        Slot sourceSlot = this.qimGetSlot(sourceSlotId);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return;
        }
        minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, sourceSlotId, 0, ClickType.PICKUP, player);
        if (this.f_97732_.m_142621_().m_41619_()) {
            return;
        }
        this.qimPlaceCarriedIntoPlayerSlots(targetSlotIds, minecraft, player, true);
        this.qimPlaceCarriedIntoPlayerSlots(targetSlotIds, minecraft, player, false);
        if (!this.f_97732_.m_142621_().m_41619_()) {
            minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, -999, 1, ClickType.THROW, player);
        }
    }

    @Unique
    private void qimPlaceCarriedIntoPlayerSlots(List<Integer> targetSlotIds, Minecraft minecraft, Player player, boolean mergeOnly) {
        for (Integer targetSlotId : targetSlotIds) {
            ItemStack carried = this.f_97732_.m_142621_();
            if (carried.m_41619_()) {
                return;
            }
            Slot targetSlot = this.qimGetSlot(targetSlotId);
            if (!this.qimCanPlaceCarriedInPlayerSlot(targetSlot, carried, mergeOnly)) continue;
            minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, targetSlotId.intValue(), 0, ClickType.PICKUP, player);
        }
    }

    @Unique
    private boolean qimCanPlaceCarriedInPlayerSlot(@Nullable Slot targetSlot, ItemStack carried, boolean mergeOnly) {
        if (targetSlot == null || !this.qimIsPlayerInventorySlot(targetSlot) || !targetSlot.m_5857_(carried)) {
            return false;
        }
        ItemStack targetStack = targetSlot.m_7993_();
        if (mergeOnly) {
            if (targetStack.m_41619_() || !ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)carried)) {
                return false;
            }
            int maxCount = Math.min(targetSlot.m_6641_(), carried.m_41741_());
            return targetStack.m_41613_() < maxCount;
        }
        return targetStack.m_41619_();
    }

    @Unique
    private List<Integer> qimCollectPlayerStorageSlots() {
        ArrayList<Integer> backpackSlots = new ArrayList<Integer>();
        ArrayList<Integer> hotbarSlots = new ArrayList<Integer>();
        for (int slotId = 0; slotId < this.f_97732_.f_38839_.size(); ++slotId) {
            Slot slot = this.qimGetSlot(slotId);
            if (slot == null || !this.qimIsPlayerInventorySlot(slot)) continue;
            int playerSlotIndex = slot.m_150661_();
            if (playerSlotIndex >= 9 && playerSlotIndex <= 35) {
                backpackSlots.add(slotId);
                continue;
            }
            if (playerSlotIndex < 0 || playerSlotIndex > 8) continue;
            hotbarSlots.add(slotId);
        }
        backpackSlots.addAll(hotbarSlots);
        return backpackSlots;
    }

    @Unique
    private boolean qimTryReturnCarriedToSource(List<Integer> sourceSlotIds, Minecraft minecraft, Player player) {
        for (Integer slotId : sourceSlotIds) {
            ItemStack existing;
            ItemStack carried = this.f_97732_.m_142621_();
            if (carried.m_41619_()) {
                return true;
            }
            Slot slot = this.qimGetSlot(slotId);
            if (slot == null || !slot.m_5857_(carried) || !(existing = slot.m_7993_()).m_41619_() && (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)carried) || existing.m_41613_() >= existing.m_41741_())) continue;
            minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, slotId.intValue(), 0, ClickType.PICKUP, player);
        }
        return this.f_97732_.m_142621_().m_41619_();
    }

    @Unique
    private List<ItemStack> qimCollectPreviewStacks(boolean playerInventorySide) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Integer slotId : this.qimSelectedSlotIds) {
            Slot slot = this.qimGetSlot(slotId);
            if (!this.qimCanMoveSlot(slot) || this.qimIsPlayerInventorySlot(slot) != playerInventorySide) continue;
            stacks.add(slot.m_7993_().m_41777_());
        }
        return stacks;
    }

    @Unique
    private void qimToggleSelection(Slot slot) {
        int slotId = this.qimSlotId(slot);
        if (slotId < 0) {
            return;
        }
        if (this.qimSelectedSlotIds.contains(slotId)) {
            this.qimSelectedSlotIds.remove(slotId);
        } else {
            this.qimSelectedSlotIds.add(slotId);
        }
    }

    @Unique
    private void qimCleanupSelection() {
        Iterator<Integer> iterator = this.qimSelectedSlotIds.iterator();
        while (iterator.hasNext()) {
            int slotId = iterator.next();
            Slot slot = this.qimGetSlot(slotId);
            if (this.qimCanMoveSlot(slot)) continue;
            iterator.remove();
        }
    }

    @Unique
    private void qimReplayPickupClick(int slotId, int button) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.f_91072_ == null) {
            return;
        }
        minecraft.f_91072_.m_171799_(this.f_97732_.f_38840_, slotId, button, ClickType.PICKUP, (Player)player);
    }

    @Unique
    private void qimResetBoxSelectionState() {
        this.qimIsBoxSelectCandidate = false;
        this.qimIsBoxSelecting = false;
        this.qimBoxCandidateSlotId = -999;
    }

    @Unique
    private void qimResetMoveDragState() {
        this.qimIsMoveDragCandidate = false;
        this.qimIsMoveDragging = false;
        this.qimMoveCandidateSlotId = -999;
        this.qimPreviewStacks.clear();
    }

    @Unique
    private void qimClearState() {
        this.qimSelectedSlotIds.clear();
        this.qimBoxSelectionMode = BoxSelectMode.REPLACE;
        this.qimResetBoxSelectionState();
        this.qimResetMoveDragState();
    }

    @Unique
    private boolean qimCanMoveSlot(@Nullable Slot slot) {
        if (!this.qimCanSelectSlot(slot)) {
            return false;
        }
        return this.qimSlotId(slot) >= 0;
    }

    @Unique
    private boolean qimCanSelectSlot(@Nullable Slot slot) {
        if (slot == null) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        return SlotSelectionRules.canSelect(slot, (Player)player, this.qimIsPlayerInventorySlot(slot));
    }

    @Unique
    private boolean qimIsPlayerInventorySlot(Slot slot) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        return player != null && slot.f_40218_ == player.m_150109_();
    }

    @Unique
    private int qimSlotIdOrOutside(@Nullable Slot slot) {
        int slotId = this.qimSlotId(slot);
        return slotId >= 0 ? slotId : -999;
    }

    @Unique
    private int qimSlotId(@Nullable Slot slot) {
        if (slot == null) {
            return -1;
        }
        return this.f_97732_.f_38839_.indexOf((Object)slot);
    }

    @Unique
    @Nullable
    private Slot qimGetSlot(int slotId) {
        if (slotId < 0 || slotId >= this.f_97732_.f_38839_.size()) {
            return null;
        }
        return (Slot)this.f_97732_.f_38839_.get(slotId);
    }

    @Unique
    private boolean qimRectsOverlap(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }

    @Unique
    private boolean qimIsDragThresholdReached(double startX, double startY, double endX, double endY) {
        double delta = Math.abs(endX - startX) + Math.abs(endY - startY);
        return delta > 4.0;
    }

    @Unique
    private BoxSelectMode qimResolveBoxSelectMode() {
        boolean defaultAdd = QuickInvMoveClientConfig.defaultBoxSelectAdd();
        boolean shiftInvert = Screen.m_96638_();
        boolean useAdd = shiftInvert ? !defaultAdd : defaultAdd;
        return useAdd ? BoxSelectMode.ADD : BoxSelectMode.REPLACE;
    }
}

